		page	,132
		title	KBUF128 - Expands type ahead buffer
comment	$

This program s based on one in the article:

Using Dummy Device Drivers to Load Terminate-and-Stay-Resident Programs
Computer Language, July 1989, Volume 6, Number 7 page 81

Assemble, link and convert as follows:
MASM KBUF128;
LINK KBUF128;
EXE2BIN KBUF128 KBUF128.SYS
DEL KBUF128.EXE

Install by adding the line to CONFIG.SYS:
DEVICE=KBUF128.SYS

Note:	you can not "LOADHI" this program
	Must use with DOS 3.xx or higher

This program changes the default buffer ponters to a new area
contained herein if this new area is reachable through segement
40h. This new buffer will hold "chars" characters and is "chars" 
words long. The buffer is reset to empty. If the "too high" error 
message is displayed, move the line closer to the front of CONFIG.SYS. 

The program has been changed somewhat from that shown in the
article.  DOS 2.xx is not supported which eliminates a great deal
of logic for adjusting the buffer position - Craig Payne.

$

chars		equ	256			; size of new buffer
bytes		equ	chars*2			; must be multiple of 16

dos_int		equ	21h
disp_mess	equ	9
get_version	equ	30h

io_packet	struc
io_cmdlen	db	?
io_unit		db	?
io_cmd		db	?
io_status	dw	?
		db	8 dup (?)
io_media	db	?
io_address	dw	?, ?
io_count	dw	?
io_start	dw	?
io_packet	ends

data		segment at 40h			; rom bios data area
		org	1ah
buffer_head	dw	?
buffer_tail	dw	?

		org	80h
buffer_start	dw	?
buffer_end	dw	?
data		ends

cseg		segment
		assume	cs:cseg, ds:nothing, es:nothing
		org	0			; for all device dirvers

header		dd	-1			; end of the ptr chain, one device
		dw	8000h			; char device flags
		dw	strat			; pointer to strategy routine
		dw	intr			; pointer to interrupt routine
		db	'Kbuf128 '		; dummy device name

; Resident portion of device driver

; KBUF128 has no resident code, just a buffer and some initialization code.


; N O T E  -  The following is different from the program presented in the 
; article.  In this version the buffer is explicitly declared.  The origional
; program EQUated the buffer to lie on top of the code to reduce the size of
; the code file.  Clever but (as they warn) if you type while the driver is
; installing your strokes will over-write the code.

newbuff		db	bytes dup (?)
endbuff		equ	$

; end of resident portion of driver

packet		dd	0			;request packet address

init		proc	far
		assume ds:nothing, es:nothing

strat:
		mov	word ptr packet,bx	;save packet ptr
		mov	word ptr packet+2,es
		ret

intr:
		push	ax
		push	bx
		push	cx
		push	dx
		push	ds

		mov	ah,get_version		;check dos version
		int	dos_int
		lea	dx,dos_ver_mess		;anticipate message
		sub	cx,cx			;driver end of zero on error
		cmp	al,3			;must be dos 3.0 or >
		jb	exit

		mov	ax,cs			;from this segment address
		sub	ax,seg data		;subtract the data address
		lea	dx,too_hi_mess		;anticipate mess
		sub	cx,cx			;driver end of zero on error
		cmp	ax,1000h-(bytes/16)	;test if within segment
		jnb	exit			;no, do not change pointers

		add	ax,ax			;convert to byte diff.
		add	ax,ax
		add	ax,ax
		add	ax,ax
		add	ax,offset newbuff	;calc offset of beginning
		mov	bx,seg data		;change pointers
		mov	ds,bx
		assume	ds:data
		sti				;lock out interrupts
		mov	buffer_head,ax		;while we change the pointers
		mov	buffer_tail,ax
		mov	buffer_start,ax
		add	ax,bytes
		mov	buffer_end,ax
		cli

		lea	dx,inst_mess
		lea	cx,endbuff

; At this point dx should point to exit message and cx to code end

exit:
		lds	bx,packet		;point to request packet
		assume	ds:nothing
		mov	[bx].io_address,cx	;set offset of driver end
		mov	[bx].io_address+2,cs	;set segment of driver end
		mov	[bx].io_status,100h	;set done flag

		mov	ax,cs			;set ds to cseg for DOS calls
		mov	ds,ax
		assume	ds:cseg
		mov	ah,disp_mess		;pump out the message in dx
		int	dos_int

		pop	ds
		pop	dx
		pop	cx
		pop	bx
		pop	ax
		ret				;exit device driver install
init		endp

inst_mess	db	"Kbuf128: v1.0 installed", 0dh, 0ah, "$"
too_hi_mess	db	"Kbuf128: did not install, too high in memory"
		db	0dh, 0ah, "$"
dos_ver_mess	db	"Kbuf128: did not install, must use DOS 3.0 or later"
		db	0dh, 0ah, "$"

cseg		ends
		end

