/*
   Ausgelagerte Routinen fr TF_FIXED.C--
*/

void CrossProduct (fixed ax; fixed ay; fixed az; fixed bx; fixed by; fixed bz; 
		 word adrx, adry, adrz) 
{
 SI = adrx ;
 DSFIXED[SI] = FMUL(fixed ay, fixed bz) ;
 DSFIXED[SI] -= FMUL(fixed az, fixed by) ;
 SI = adry ;
 DSFIXED[SI] = FMUL(fixed az, fixed bx) ;
 DSFIXED[SI] -= FMUL(fixed ax, fixed bz) ;
 SI = adrz ;
 DSFIXED[SI] = FMUL(fixed ax, fixed by) ;
 DSFIXED[SI] -= FMUL(fixed ay, fixed bx) ;
}

fixed DotProduct (fixed ax; fixed ay; fixed az; fixed bx; fixed by; fixed bz) 
{
 $ XOR  ECX, ECX
 $ MOV  EAX, ax
 $ IMUL bx
 $ MOV  AX, DX
 $ ROR  EAX, 16
 $ ADD  ECX, EAX
 $ MOV  EAX, ay
 $ IMUL by
 $ MOV  AX, DX
 $ ROR  EAX, 16
 $ ADD  ECX, EAX
 $ MOV  EAX, az
 $ IMUL bz
 $ MOV  AX, DX
 $ ROR  EAX, 16
 $ ADD  EAX, ECX
}

void Init_sin_tab ()
fixed x, dx ;
word i ;
{
 dx = FIDIV(fixed Pix2, fixed 0x4000000) ;
 x = 0 ; i = 1024 ; DI = 0 ;
 loop (i) {
  DSFIXED[#sin_tab+DI] = FSin(fixed x) ;
  x += dx ; DI += 4 ;
 }
}

void rotate_points ()
fixed si_x, co_x, si_y, co_y, si_z, co_z ;
fixed temp_x, temp_y, temp_z ;
word i ;
{
 GS = rpoints ; FS = points ;
 AX = angle_x & 1023 << 2 ; SI = AX ;
 AX = angle_x+256 & 1023 << 2 ; DI = AX ; 
 si_x = sin_tab[SI] ; co_x = sin_tab[DI] ;
 AX = angle_y & 1023 << 2 ; SI = AX ;
 AX = angle_y+256 & 1023 << 2 ; DI = AX ;
 si_y = sin_tab[SI] ; co_y = sin_tab[DI] ;
 AX = angle_z & 1023 << 2 ; SI = AX ;
 AX = angle_z+256 & 1023 << 2 ; DI = AX ;
 si_z = sin_tab[SI] ; co_z = sin_tab[DI] ;
 i = no_points ;
 loop (i) {
  AX = i-1 * 12 ; SI = AX ;
  temp_x = FSFIXED[SI] - rotpos_x ; 
  temp_y = FSFIXED[SI+4] - rotpos_y ; 
  temp_z = FSFIXED[SI+8] - rotpos_z ;

  GSFIXED[SI+4] = FMUL(fixed co_x, fixed temp_y) ; 
  GSFIXED[SI+4] -= FMUL(fixed si_x, fixed temp_z) ;
  GSFIXED[SI+8] = FMUL(fixed si_x, fixed temp_y) ; 
  GSFIXED[SI+8] += FMUL(fixed co_x, fixed temp_z) ;

  temp_z = GSFIXED[SI+8] ;
  GSFIXED[SI] = FMUL(fixed co_y, fixed temp_x) ;
  GSFIXED[SI] -= FMUL(fixed si_y, fixed temp_z) ;
  GSFIXED[SI+8] = FMUL(fixed si_y, fixed temp_x) ;
  GSFIXED[SI+8] += FMUL(fixed co_y, fixed temp_z) ;

  temp_x = GSFIXED[SI] ; temp_y = GSFIXED[SI+4] ; 
  GSFIXED[SI] = FMUL(fixed co_z, fixed temp_x) ; 
  GSFIXED[SI] -= FMUL(fixed si_z, fixed temp_y) ;
  GSFIXED[SI+4] = FMUL(fixed si_z, fixed temp_x) ;
  GSFIXED[SI+4] += FMUL(fixed co_z, fixed temp_y) ;

  GSFIXED[SI] += rotpos_x ; 
  GSFIXED[SI+4] += rotpos_y ; 
  GSFIXED[SI+8] += rotpos_z ;
 }
}
