unit Unicode;

interface

procedure loadUniTable (FName : string);
function trUCode (UCode : integer) : char;

{-------------------------------------------------------------------------}

implementation

const
  MAX_TABLE = 256;

var
  UniTab : array [1..MAX_TABLE] of integer;
  DosTab : array [1..MAX_TABLE] of byte;
  TabTop : integer;


function hex2num (cc : char) : byte;
begin
  if cc in ['0' .. '9'] then hex2num := ord (cc) - 48;
  if cc in ['a' .. 'f'] then hex2num := ord (cc) - 87;
  if cc in ['A' .. 'F'] then hex2num := ord (cc) - 55;
end;


procedure loadUniTable (FName : string);

var
  IFile : text;
  Line : string;

begin
  assign (IFile, FName);
{$I-}
  reset (IFile);
{$I+}
  if IOResult <> 0 then exit;

  TabTop := 0;
  while (not eof (IFile)) and (TabTop < MAX_TABLE) do begin
    readln (IFile, Line);
    inc (TabTop);
    UniTab [TabTop] := $1000 * hex2num (Line[1]) + $100 * hex2num (Line[2]) + $10 * hex2num (Line[3]) + hex2num (Line[4]);
    if Line[7] = '''' then
      DosTab [TabTop] := ord (Line[6])
    else
      DosTab [TabTop] := $10 * hex2num (Line[6]) + hex2num (Line[7]);
  end;
  close (IFile);
end;


function trUCode (UCode : integer) : char;

var
  i, j, k : integer;

begin
  if UCode < 128 then begin
    trUCode := chr (Lo (UCode));
    exit;
  end;
  if TabTop = 0 then begin
    if UCode < 256 then trUCode := chr (Lo (UCode))
                   else trUCode := #0;
    exit;
  end;
  
  i := 1;
  j := TabTop;
  repeat
    k := (i + j) div 2;
    if UCode > UniTab[k] then i := k + 1
                         else j := k - 1;
  until (UCode = UniTab[k]) or (i > j);

  if UCode = UniTab[k] then
    trUCode := chr (DosTab[k])
  else
    if UCode < 256 then
      trUCode := chr (Lo (UCode))
    else  
      trUCode := #0;
end;


begin
  TabTop := 0;
end.