@ECHO OFF
REM @ECHO OFF will turn the echoing off. Take it off and see the
REM difference.

REM                 Batch files utility collection
REM              Programs and manual by Javier Thaine
REM                   Demonstration batch file
REM To place a comment in a batch file, just type REM at the
REM beggining of the line, a space and your comment.

rem Commands are not case-sensitive.

cls
REM CLS will clear the screen.

REM The ECHO command followed by a space and text will display
REM the text on the screen.
REM ECHO followed by a period (.) will display a blank line
ECHO                 Batch files utility collection     
ECHO              Programs and manual by Javier Thaine
ECHO                   Demonstration batch file
ECHO.
ECHO First, I will demonstrate the use of the KEY command.
ECHO Press the A key with caps lock off.
KEY
IF ERRORLEVEL 97 IF NOT ERRORLEVEL 98 ECHO You just pressed a lowercase A.
ECHO Now, press the A key with caps lock on.
KEY
IF ERRORLEVEL 65 IF NOT ERRORLEVEL 66 ECHO You just pressed an uppercase A.
ECHO Now, I will demonstrate the use of the KEYUPR command.
ECHO Press the A key with caps lock off.
KEYUPR
IF ERRORLEVEL 65 IF NOT ERRORLEVEL 66 ECHO You just pressed an uppercase A.
ECHO Now, press the A key with caps lock on.
KEYUPR
IF ERRORLEVEL 65 IF NOT ERRORLEVEL 66 ECHO You just pressed an uppercase A.
ECHO Now, I will demonstrate the use of the KEYLWR command.
ECHO Press the A key with caps lock off.
KEYLWR
IF ERRORLEVEL 97 IF NOT ERRORLEVEL 98 ECHO You just pressed a lowercase A.
ECHO Now, press the A key with caps lock on.
KEYLWR
IF ERRORLEVEL 97 IF NOT ERRORLEVEL 98 ECHO You just pressed a lowercase A.
PAUSE
REM Try the pause command and see what it does. It can often be useful.
CLS
ECHO Now, I will demonstrate the use of the TEXTMODE command.
PAUSE
MODE 40
ECHO Aren't these letters annoying?
ECHO Just use TEXTMODE.COM to turn
ECHO them back to normal.
PAUSE
TEXTMODE
ECHO Isn't this a whole lot better?
PAUSE
CLS
ECHO Now, I will demonstrate the DETVGA command.
ECHO We will find out if you have a VGA-compatible card or not.
ECHO.
DETVGA
IF ERRORLEVEL 0 IF NOT ERRORLEVEL 1 ECHO You do have a VGA-compatible graphics card!
IF ERRORLEVEL 1 IF NOT ERRORLEVEL 2 ECHO You DON'T have a VGA-compatible graphics card!
PAUSE
CLS
ECHO Now, I will demonstrate the BEEP command.
PAUSE
BEEP
ECHO Did you hear it? I certainly hope you did.
PAUSE
ECHO Now, I will demonstrate the DELAY command.
PAUSE
ECHO One second delay.
DELAY 1000
ECHO Two seconds delay.
DELAY 2000
ECHO Half second delay.
DELAY 500
PAUSE
CLS
ECHO Now I will demonstrate the SOUND and NOSOUND commands.
PAUSE
ECHO 500Hz tone.
SOUND 500
PAUSE
ECHO 1500Hz tone.
SOUND 1500
PAUSE
ECHO 5000Hz tone.
SOUND 5000
PAUSE
ECHO 100Hz tone.
SOUND 100
PAUSE
ECHO Sound turned off.
NOSOUND
PAUSE
CLS
ECHO Now I will demonstrate the SOUND, NOSOUND and DELAY commands
ECHO used together.
PAUSE
ECHO 500Hz tone for 500 milliseconds.
SOUND 500
DELAY 500
ECHO 600Hz tone for 1000 milliseconds.
SOUND 600
DELAY 1000
ECHO 700Hz tone for 100 milliseconds.
SOUND 700
DELAY 100
ECHO 400Hz tone for 2000 milliseconds.
SOUND 400
DELAY 2000
ECHO 300Hz tone for 300 milliseconds.
SOUND 300
DELAY 300
ECHO Sound turned off.
NOSOUND
PAUSE
CLS
ECHO Now I will demonstrate the YESNO command.
ECHO Press either y or n.
YESNO
IF ERRORLEVEL 0 IF NOT ERRORLEVEL 1 ECHO You pressed N for no.
IF ERRORLEVEL 1 IF NOT ERRORLEVEL 2 ECHO You pressed Y for yes.
ECHO Press either y or n.
YESNO
IF ERRORLEVEL 0 IF NOT ERRORLEVEL 1 ECHO You pressed N for no.
IF ERRORLEVEL 1 IF NOT ERRORLEVEL 2 ECHO You pressed Y for yes.
ECHO Press either y or n.
YESNO
IF ERRORLEVEL 0 IF NOT ERRORLEVEL 1 ECHO You pressed N for no.
IF ERRORLEVEL 1 IF NOT ERRORLEVEL 2 ECHO You pressed Y for yes.
ECHO Press either y or n.
YESNO
IF ERRORLEVEL 0 IF NOT ERRORLEVEL 1 ECHO You pressed N for no.
IF ERRORLEVEL 1 IF NOT ERRORLEVEL 2 ECHO You pressed Y for yes.
PAUSE
CLS
ECHO Thank you for using my demonstration batch file.
ECHO            Javier Thaine.
