/* --------------------------------------------------------------------
   Project: PAL: Palmtop Application Library
   Module:  FILE.C
   Author:  Jean-Jacques Moreau
   Started: 11. Aug. 99
   Subject: File manipulation functions
   -------------------------------------------------------------------- */

/* --------------------------------------------------------------------
                          standard includes
   -------------------------------------------------------------------- */
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

/* --------------------------------------------------------------------
                            msdos includes
   -------------------------------------------------------------------- */
#include <dos.h>

/* --------------------------------------------------------------------
                           local includes
   -------------------------------------------------------------------- */
#include "pal.h"
#include "palpriv.h"

/* --------------------------------------------------------------------
                           global variables
   -------------------------------------------------------------------- */

/* --------------------------------------------------------------------
                           Functions
   -------------------------------------------------------------------- */

/* --------------------------------------------------------------------
   Filename:
   Return the name of the file, stripping out the directory and
   extension.
   -------------------------------------------------------------------- */

char *Filename(char *pFullPath)
{
   char *pName;
   char *pSlash;
   char *pDot;

   pSlash = strrchr(pFullPath, '\\');
   if (pSlash != NULL)
      pName = strdup(pSlash);
   else
      pName = strdup(pFullPath);

   pDot = strrchr(pName, '.');
   if (pDot != NULL)
      *pDot = 0;

   return pName;
}

