'/* VIEW.BAS  Browse a file in binary mode */
'/*           By: Dale Thorn               */
'/*           Rev. 02.04.2003              */

defint a-z
deflng x

const KEY.CLR = 188                         'colour/b&w mode toggle key (+ 128)
const KEY.CSD = 208                                    'cursor-down key (+ 128)
const KEY.CSL = 203                                    'cursor-left key (+ 128)
const KEY.CSR = 205                                   'cursor-right key (+ 128)
const KEY.CSU = 200                                      'cursor-up key (+ 128)
const KEY.END = 207                                            'end key (+ 128)
const KEY.ESC =  27                                         'Escape key
const KEY.HOM = 199                                           'home key (+ 128)
const KEY.MOD = 190                                    'modify-text key (+ 128)
const KEY.PGD = 209                                      'page-down key (+ 128)
const KEY.PGL = 243                                      'page-left key (+ 128)
const KEY.PGR = 244                                     'page-right key (+ 128)
const KEY.PGU = 201                                        'page-up key (+ 128)
const KEY.SHO = 187                              'show binary chars key (+ 128)
const KEY.TBL = 143                                       'tab-left key (+ 128)
const KEY.TBR =   9                                      'tab-right key

type bpas
   cdos as integer              'standard DOS colour (specified in clrparm.bas)
   cdot as integer                              'ASCII value for period/dot (.)
   ceof as integer                           'ASCII value for DOS EOF character
   cinv as integer                       'inverse video colour (black-on-white)
   fcno as integer                               'main file channel/unit number
   flen as integer                                       'length of file buffer
   knum as integer                                          'current key number
   llen as integer                               'relative file 'record' length
   lmax as integer                                'maximum no. of display lines
   lwid as integer                                  'maximum display-line width
   twid as integer                                   'standard "hard" tab width
   xcno as integer                          'auxiliary-file channel/unit number
end type

declare function ifn.msgs(cmsg$, iofs, irow, icol, ibeep, iexit)
declare function midchar(cstr1$, ipos)
declare sub browse(bp as bpas, brfile$, brrepl$(), char$())

dim brrepl$(32), char$(255)
dim bp as bpas

'$include: 'clrparm.bas'
'$include: 'scrnparm.bas'

bp.cdos = iclr                                     'set the standard DOS colour
bp.cinv = iclr \ 16 + (iclr mod 8) * 16           'set DOS inverse video colour
bp.cdot =  46                                   'ASCII value for period/dot (.)
bp.ceof =  26                                'ASCII value for DOS EOF character
bp.fcno =   1                                    'main file channel/unit number
bp.xcno =   2                               'auxiliary-file channel/unit number

call nosnow(0)            'turns off snow suppression when linking with PDQ.LIB
color iclr mod 16, iclr \ 16                     'set DOS color to clear screen
if command$ = "" then                      'a parameter string was NOT supplied
   i = ifn.msgs("Usage:  VIEW  filename  [recordlen]", 5, 24, 79, 0, 1)
else                                       'a parameter string was NOT supplied
   for i = 1 to 32                'loop thru binary/view replacement characters
       brrepl$(i) = space$(1)    'create the binary/view replacement characters
   next
   for i = 0 to 255                 'loop thru the CHR$() substitute characters
       char$(i) = chr$(i)              'create the CHR$() substitute characters
   next
   brfile$ = ucase$(rtrim$(command$))                      'file specifications
   ipos1 = instr(brfile$, " ")
   ipos2 = instr(brfile$, "/")
   if ipos2 = 0 then
      ipos2 = ipos1
   end if
   if ipos2 then
      ircdlen = cint(val(mid$(brfile$, ipos2 + 1)))
      if ircdlen = 0 then
         ircdlen = 80
      end if
      brfile$ = left$(brfile$, ipos2 - 1)
   else
      ircdlen = 80
   end if
   bp.flen = irow * ircdlen                              'length of file buffer
   bp.llen = ircdlen                             'relative file 'record' length
   bp.lmax = irow                                 'maximum no. of display lines
   bp.lwid = icol                                   'maximum display-line width
   bp.twid = 8                                       'standard "hard" tab width
   bp.knum = KEY.HOM                                'set current key = home key
   if bp.lwid > bp.llen then
      bp.lwid = bp.llen
   end if
   call browse(bp, brfile$, brrepl$(), char$())
   color iclr mod 16, iclr \ 16                  'set DOS color to clear screen
   i = ifn.msgs("", 5, 24, 79, 0, 1)      'clear the screen and exit to the O/S
end if

close                                 'close all files in case not closed above
system                                  'return control to the operating system

sub browse(bp as bpas, brfile$, brrepl$(), char$())
    bufsiz  = bp.flen * 2                             'size of main data buffer
    brattr$ = ""                           'binary mode colour attribute buffer
    brbuff$ = ""                           'main data buffer used by browse sub
    brchar$ = ""                            'alternate character display buffer
    brfrec$ = space$(1)                       'main file buffer (variable len.)
    open brfile$ for binary as bp.fcno       'open the main file for read/write
    if lof(bp.fcno) = 0 then
       close bp.fcno
       open brfile$ for binary access read as bp.fcno  'open file for read-only
    end if
    xlof = lof(bp.fcno)                              'length of the browse file
    if xlof = 0 then                          'length = 0; kill and exit browse
       call killfile(brfile$, bp.fcno)                    'kill the browse file
       cls                                                        'clear screen
       call pdqprint(brfile$ + " not found", 5, 5, bp.cdos)  'not-found message
       locate 6, 1, 1                                          'position cursor
       beep                                                         'user alert
       system                                                    'return to DOS
    end if
    locate bp.lmax, bp.lwid, 0               'move cursor to lower right corner
    open "view.exe" for binary as bp.xcno             'test for VIEW.EXE exist.
    xlen = lof(bp.xcno)                                'length of VIEW.EXE file
    if xlen then                                                 'length is > 0
       call fileio(bp.xcno, 1, xlen, brfrec$, 0)         'get last byte in file
       ichr = (asc(brfrec$) = bp.ceof)                 'TRUE if last byte = EOF
       for i = 1 to 32                       'get binary replacement characters
           call fileio(bp.xcno, 1, xlen + i + ichr - 32, brfrec$, 0)
           lset brrepl$(i) = brfrec$                    'fill replacement array
       next
       close bp.xcno                                       'close VIEW.EXE file
    else
       call killfile("view.exe", bp.xcno)          'kill file header if LOF = 0
       for i = 1 to 32                          'default replacement characters
           lset brrepl$(i) = mid$("0ABCDEFGHIJKLMNOPQRSTUVWXYZ78931", i, 1)
       next
    end if
    brattr$ = space$(bufsiz)               'binary mode colour attribute buffer
    brchar$ = space$(bufsiz)                'alternate character display buffer
    brfrec$ = space$(bp.flen)                          're-allocate file buffer
    xmaxln  = xlof \ bp.llen              'total lines (bp.llen) in browse-file
    xmaxln  = xmaxln - (xlof - xmaxln * bp.llen > 0)   'add modulo to max.lines
    showbc  = 0                              'display alternate characters flag
    brbuff$ = space$(bufsiz)               'main data buffer used by browse sub
    recmax  = xlof \ bp.flen            'total records (bp.flen) in browse file
    modlen  = bp.flen - xlof mod bp.flen    'no. of nulls to insert into buffer
    modpos  = bufsiz - modlen + 1         'position to insert nulls into buffer
    modptr  = bp.flen - modlen + 1        'position to insert nulls into buffer
    recmax  = recmax - (modlen > 0)                  'add modulo to max.records
    recnum  = 0                                   'current file "record" number
    while bp.knum <> KEY.ESC                         'first time in; key = home
       if recnum then                 'no key-get if recnum = 0 (first time in)
          call getkeybuf(bp.knum)             'get user key after first time in
       end if
       shflen = 0                                           'buffer shift value
       if bp.knum <> KEY.MOD or bp.llen <= bp.lwid then
          gosub binproc                         'binary mode user-key processor
       end if
    wend
    exit sub                                         'return to calling program
    '--------------------------------------------------------------------------
    binproc:          'process key entries  (binary mode)
    '--------------------------------------------------------------------------
    select case bp.knum
       case KEY.CLR
          if bp.cdos = 112 then
             bp.cdos = 31
          else
             bp.cdos = 112
          end if
          bp.cinv = bp.cdos \ 16 + (bp.cdos mod 8) * 16
          gosub disptextb
       case KEY.CSD
          if endptr < xmaxln - clng(recnum - 2) * bp.lmax then
             if endptr = bp.lmax * 2 then
                shfrec = 1
                shflen = -bp.lmax
                gosub getrec
             end if
             endptr = endptr + 1
             gosub disptextb
          end if
       case KEY.CSL, KEY.PGL, KEY.TBL
          if offset then
             if bp.knum = KEY.CSL then offset = offset - 1
             if bp.knum = KEY.PGL then offset = offset - bp.lwid
             if bp.knum = KEY.TBL then offset = offset - bp.twid
             if offset < 0 then offset = 0
             gosub disptextb
          end if
       case KEY.CSR, KEY.PGR, KEY.TBR
          if bp.knum = KEY.CSR then offset = offset + 1
          if bp.knum = KEY.PGR then offset = offset + bp.lwid
          if bp.knum = KEY.TBR then offset = offset + bp.twid
          gosub disptextb
       case KEY.CSU
          if endptr > bp.lmax or recnum > 2 then
             if endptr = bp.lmax then
                shfrec = -1
                shflen = bp.lmax
                gosub getrec
             end if
             endptr = endptr - 1
             gosub disptextb
          end if
       case KEY.END
          if endptr < xmaxln - clng(recnum - 2) * bp.lmax then
             if recnum < recmax then
                shfrec = recmax - recnum
                gosub getrec
             end if
             endptr = xmaxln - clng(recnum - 2) * bp.lmax
             gosub disptextb
          else
             if offset > 0 then gosub disptextb
          end if
       case KEY.HOM
          if endptr > bp.lmax or recnum <> 2 then
             if recnum <> 2 then
                shfrec = 2 - recnum
                gosub getrec
             end if
             if bp.lmax > xmaxln then
                endptr = xmaxln
             else
                endptr = bp.lmax
             end if
             gosub disptextb
          else
             if offset > 0 then gosub disptextb
          end if
       case KEY.MOD
          for ilin = bp.lmax - 2 to bp.lmax
              call pdqprint(space$(bp.lwid), ilin, 1, colour)
          next
          ilen = 0
          brtext$ = ""
          locate bp.lmax - 2, 2, 1
          line input "Row: ", brtext$
          if len(brtext$) then
             irow = val(brtext$)
             brtext$ = ""
             locate bp.lmax - 2, 12, 1
             line input "Col: ", brtext$
             if len(brtext$) then
                icol = val(brtext$)
                brtext$ = ""
                locate bp.lmax - 2, 22, 1
                line input "Char: ", brtext$
                if len(brtext$) then
                   ichr = val(brtext$)
                   if irow >= 1 and irow <= bp.lmax then
                      if icol >= 1 and icol <= bp.lwid then
                         if ichr >= 0 and ichr <= 255 then ilen = not 0
                      end if
                   end if
                end if
             end if
          end if
          if ilen then
             xrec = clng(recnum - 2) * bp.lmax * bp.llen
             if endptr < bp.lmax then
                iptr = bp.lmax
             else
                iptr = endptr
             end if
             ipos = (irow + iptr - bp.lmax - 1) * bp.llen + icol
             if xrec + ipos <= xlof then
                call fileio(bp.fcno, 1, xrec + ipos, char$(ichr), -1)
                if ichr < 32 then
                   mid$(brattr$, ipos) = char$(bp.cinv)
                   mid$(brbuff$, ipos) = char$(bp.cdot)
                   ichr = asc(brrepl$(ichr + 1))
                else
                   mid$(brattr$, ipos) = char$(bp.cdos)
                   mid$(brbuff$, ipos) = char$(ichr)
                end if
                mid$(brchar$, ipos) = char$(ichr)
             else
                ilen = 0
             end if
          end if
          if not ilen then
             call pdqprint("No change.  Hit any key.", bp.lmax, 1, colour)
             beep
             call getkey(i)
          end if
          gosub disptextb
          locate bp.lmax, bp.lwid, 0
       case KEY.PGD
          if endptr < xmaxln - clng(recnum - 2) * bp.lmax then
             if recnum < recmax and endptr > bp.lmax then
                shfrec = 1
                gosub getrec
             else
                endptr = endptr + bp.lmax
             end if
             xendlin = xmaxln - clng(recnum - 2) * bp.lmax
             if endptr > xendlin then endptr = xendlin
             gosub disptextb
          end if
       case KEY.PGU
          if endptr > bp.lmax or recnum > 2 then
             if recnum > 2 and endptr < bp.lmax * 2 then
                shfrec = -1
                gosub getrec
             else
                endptr = bp.lmax
             end if
             gosub disptextb
          end if
       case KEY.SHO
          showbc = not showbc
          gosub disptextb
       case else
    end select
    return
    '--------------------------------------------------------------------------
    disptextb:     'display screen text lines  (binary mode)
    '--------------------------------------------------------------------------
    if bp.knum = KEY.HOM or bp.knum = KEY.END then offset = 0
    bufptr = 1 - ((endptr - bp.lmax) * bp.llen * (endptr > bp.lmax))
    tmpndx = bufptr \ bp.llen + 1
    colour = bp.cdos
    if bp.lwid + offset > bp.llen then
       ilen = bp.llen - offset
       if ilen < 0 then
          ilen = 0
       end if
    else
       ilen = bp.lwid
    end if
    for ilin = 1 to bp.lmax
        tmpptr = bufptr + offset
        bufndx = bufptr \ bp.llen + 1
        if bufndx < begndx or bufndx > endndx then
           for iptr = bufptr to bufptr + bp.llen - 1
               ichr = midchar(brbuff$, iptr)
               if ichr < 32 then
                  mid$(brattr$, iptr) = char$(bp.cinv)
                  mid$(brbuff$, iptr) = char$(bp.cdot)
                  mid$(brchar$, iptr) = brrepl$(ichr + 1)
               end if
           next
        elseif bp.knum = KEY.CLR then
           for iptr = bufptr to bufptr + bp.llen - 1
               ichr = midchar(brattr$, iptr)
               if ichr = 31 or ichr = 112 then
                  mid$(brattr$, iptr) = char$(bp.cdos)
               else
                  mid$(brattr$, iptr) = char$(bp.cinv)
               end if
           next
        end if
        if showbc then
           ibeg = tmpptr
           iend = tmpptr + ilen
           while ibeg < iend
              icol = ibeg - tmpptr + 1
              iclr = midchar(brattr$, ibeg)
              if iclr = bp.cdos then
                 ialt = bp.cinv
              else
                 ialt = bp.cdos
                 iclr = bp.cinv
              end if
              ipos = instr(ibeg, brattr$, char$(ialt))
              if ipos = 0 or ipos > iend then ipos = iend
              call pdqprint(mid$(brchar$, ibeg, ipos - ibeg), ilin, icol, iclr)
              ibeg = ipos
           wend
        else
           call pdqprint(mid$(brbuff$, tmpptr, ilen), ilin, 1, colour)
        end if
        if ilen < bp.lwid then
           call pdqprint(space$(bp.lwid - ilen), ilin, ilen + 1, colour)
        end if
        bufptr = bufptr + bp.llen
    next
    if begndx = -bp.lmax or begndx > tmpndx then begndx = tmpndx
    if begndx < 1 then begndx = 1
    if endndx = -bp.lmax or endndx < bufndx then endndx = bufndx
    if endndx > bp.lmax * 2 then endndx = bp.lmax * 2
    return
    '--------------------------------------------------------------------------
    getrec:       'get text records and fill buffer (brbuff$)
    '--------------------------------------------------------------------------
    endptr = endptr + shflen
    recnum = recnum + shfrec
    if abs(shfrec) > 1 then
       call fileio(bp.fcno, bp.flen, clng(recnum - 1), brbuff$, 0)
       if recnum >= recmax then mid$(brbuff$, modpos) = string$(modlen, 0)
       if recnum > recmax then mid$(brbuff$, modptr) = string$(bp.flen, 0)
       mid$(brattr$, 1) = string$(bufsiz, bp.cdos)
       mid$(brchar$, 1) = brbuff$
       begndx = -bp.lmax
       endndx = -bp.lmax
    else
       call fileio(bp.fcno, bp.flen, clng(recnum + (shfrec < 0)), brfrec$, 0)
       ibeg = 1
       iend = bp.flen + 1
       if shfrec > 0 then
          if recnum = recmax then mid$(brfrec$, modptr) = string$(modlen, 0)
       else
          swap ibeg, iend
       end if
       mid$(brattr$, ibeg) = mid$(brattr$, iend, bp.flen)
       mid$(brbuff$, ibeg) = mid$(brbuff$, iend, bp.flen)
       mid$(brchar$, ibeg) = mid$(brchar$, iend, bp.flen)
       mid$(brattr$, iend) = string$(bp.flen, bp.cdos)
       mid$(brbuff$, iend) = brfrec$
       mid$(brchar$, iend) = brfrec$
       if bp.knum = KEY.END then
          begndx = -bp.lmax
          endndx = -bp.lmax
       else
          begndx = begndx - bp.lmax * shfrec
          endndx = endndx - bp.lmax * shfrec
       end if
    end if
    return
end sub                                              'return to calling program

sub fileio(fcno, flen, xrec, fbuf$, fopr)                 'read/write file data
    xpos = (xrec - 1) * flen + 1                'absolute byte position in file
    if fopr then                                             'operation = write
       put fcno, xpos, fbuf$                                'write data to file
    else                                                      'operation = read
       get fcno, xpos, fbuf$                               'read data from file
    end if
end sub                                              'return to calling program

sub getkey(kkey)                             'strip key buffer and wait for key
    kkey = 0                                              'initialise key value
    while len(inkey$)                                     'strip the key buffer
    wend
    while kkey = 0                                              'wait for a key
       call getkeytst(kkey)                                'test the key buffer
    wend
end sub                                              'return to calling program

sub getkeybuf(kkey)                                           'get buffered key
    key$ = inkey$                              'single key from keyboard buffer
    while len(key$) = 0                                    'begin key-wait loop
       key$ = inkey$                             'get a key from the key buffer
    wend                                                     'end key-wait loop
    if asc(key$) then                                         'non-extended key
       kkey = asc(key$)                                     'returned key value
    else                                                          'extended key
       kkey = asc(mid$(key$, 2)) + 128                      'returned key value
    end if
end sub                                              'return to calling program

sub getkeytst(kkey)                       'strip key buffer and return last key
    kkey = 0                                              'initialise key value
    key$ = inkey$                                'get a key from the key buffer
    while len(key$)                                       'strip the key buffer
       if asc(key$) then                                      'non-extended key
          kkey = asc(key$)                                  'returned key value
       else                                                       'extended key
          kkey = asc(mid$(key$, 2)) + 128                   'returned key value
       end if
       key$ = inkey$                          'get next key from the key buffer
    wend
end sub                                              'return to calling program

function ifn.msgs(cmsg$, iofs, irow, icol, ibeep, iexit) 'display user messages
   cls                                                        'clear the screen
   locate 5, iofs, 1                                         'locate the cursor
   print cmsg$;                                       'display the user message
   if ibeep then                                 'OK to sound user-alert (beep)
      beep                                                'sound the user-alert
   end if
   if iexit then                                        'OK to exit the program
      close                                                    'close all files
      locate 6, 1, 1                                       'relocate the cursor
      system                                                     'return to DOS
   else                                                'do NOT exit the program
      locate irow, icol, 0                                    'hide' the cursor
   end if
end function

sub killfile(ffil$, fcno)                                      'kill a DOS file
   if instr(ffil$, "*") = 0 then                      'check for multiple files
      close fcno                                            'close file if open
      open ffil$ for binary as fcno                   'open file in binary mode
      close fcno                                                'close the file
      kill ffil$                                                 'kill the file
   end if
end sub

sub nosnow(i)
end sub

sub pdqprint(text$, irow, icol, iclr)
   color iclr mod 16, iclr \ 16
   locate irow, icol, 0
   print text$;
end sub
