/* VARTABS.CHS    C.R.S. Schanck       2/22/93
/* CHESS FUNCTION(S): conf_vtabs, set_vtabs, do_vtabs
/*              DATE: 3/1/93
/*            AUTHOR: C. Schanck
/*
/*       DESCRIPTION:
/*
/* Taken from two other ideas for other editors and adapted for Bingo,
/* plus a bunch of my own ideas...
/*
/* This is a module for inclusion into the .CFG/.SET file pair which
/* will add the functionality for variable tabs.  This version works 
/* off of a character representation of tabs.
/* 'conf_vtabs'   turns the use of variable tabs on and off
/* 'set_vtabs'    allows the user to edit the character rep of the tabs
/* 'do_vtabs'     a replacement for the 'insert_tab' function
/* which will either use the variable tabs or the insert_tab
/* function, depending on whether the 'vtabmode' variable is set to
/* zero or not.

/* global variables for turning variable tabs on/off
int vtabmode;
char tset[80];        /* array for tab stops                       
/* include a statment like strcpy(tset,"*   *        *        *        *");
/* for the intial tab setup
           
/* turn vtabs on and off
conf_vtabs
{
   char buf[40];
   int i;
   strcpy(buf,"Set Variable Tabs? (Now: ");
   if(vtabmode)
      strcat(buf,"ON");
   else
      strcat(buf,"OFF");
   i=box_pick(buf,3,2,"Yes, Turn ON","No, Turn OFF","Toggle Current Setting");
   if(i==0)
      vtabmode=1;
   else if(i==1)
      vtabmode=0;
   else if(i==2)
      vtabmode=1-vtabmode;
   return(1);
}

/* this lets you change the tab stop setting
set_vtabs
{
   char dest[80];
   strcpy(dest,tset);
   if(get_str(dest,"  Tabs?....0........0........0........0........0........0........0",70)!=27)
   {
      strcpy(tset,dest);
   }
}

/* this will allow you to use variable stop tabs.  The character
/* buffer 'tset' holds the columns where tabstops are set.  A non
/* space character indicates it is a tabstop.  The first column is
/* always a tab stop.  The routine will force spaces to be inserted 
/* if necessary to padd to the position.
/*
/* this should work regardless of the setting of the bounce cursor
/* mode
 
do_vtabs
{
   int i,j,curx,ok;
   char buf[20];

   if(vtabmode==0)      /* if no vtabs, do a normal tab and duck out
      return(Insert_tab());

   ok=0;                         /* set flag saying we haven't found next tab
   curx=ask("file_column");      /* current column

   if(curx<strlen(tset))
   {                 
      i=curx;
      /* ok, there could be a next tabstop */
      while(tset[i]==32)
      {              
         i=i+1;
      }

      if(tset[i]!=0)
         ok=1;

   }
      
   if(ok)                /* if we found one...
   {                                      
      i=i+1;
      
      j=0;               /* pad the string with spaces needed
      while(j<(i-curx))
      {
         buf[j]=32;
         j=j+1;
      }
      buf[j]=0;

      /* put the spaces in the file
      put_text(1,ask("file_line"),curx,buf);
      
      /* now move to the proper column
      sformat(buf,",%ld\\r",i);          
      Jump(buf);
   }
   else                          /* if not found
   {
      put_text(1,1,ask("file_line")+1,"");   /* pad 
      Begin_line();                   /* go to beginning of next line.
      Cursor_down();
   }

   /* this routine always wins, so return 1
   return(1);  
}