10 HEX

?DEFINE HPX [IF]
0 1 IN/OUT
CODE HPX
( -- ON_HPLX )
\ Returns TRUE if program runs on HPxxLX
  4DD4 # AX MOV
  15 INT
  AX AX XOR
  4850 # BX CMP =0 IF,
    AX INC
  THEN,
  RET
END-CODE
[THEN]


0 1 IN/OUT
U: MAIN_BATT
\ ( -- voltage )
\ Returns voltage (in miliVolts) of main battery
  6000 (int15)
  1B * 622 +
;

0 1 IN/OUT
U: BACK_BATT
\ ( -- voltage )
\ Returns voltage (in miliVolts) of backup battery
  6001 (int15)
  1B * 622 +
;

?DEFINE ENABLE_CHARGING [IF]
0 0 IN/OUT
CODE ENABLE_CHARGING
\ ( -- )
\ Enables charging
0 # BL MOV
  6004 # AX MOV
  15 INT
  RET
END-CODE
[THEN]

?DEFINE DISABLE_CHARGING [IF]
0 0 IN/OUT
CODE DISABLE_CHARGING
\ ( -- )
\ Disables charging
  0 # BL MOV
  6004 # AX MOV
  15 INT
  RET
END-CODE
[THEN]

?DEFINE SET_BATT [IF]
1 0 IN/OUT
CODE SET_BATT
\ ( n -- )
\ par n battery type ("Alka" or "NiCd")
\ Sets battery type
  AL BL MOV
  6003 # AX MOV
  15 INT
  RET
END-CODE
[THEN]

?DEFINE SET_CONTRAST [IF]
1 0 IN/OUT
CODE SET_CONTRAST
\ ( c -- )
\ par c contrast of display (0..15)
\ Sets contrast of display
  AL BL MOV
  4700 # AX MOV
  15 INT
  RET
END-CODE
[THEN]

?DEFINE SET_VOLUME [IF]
1 0 IN/OUT
CODE SET_VOLUME
\ ( v -- )
\ par v volume of beeper (0..3)
\ Sets volume of beeper
  48 # AH MOV
  15 INT
  RET
END-CODE
[THEN]

?DEFINE MODE80X25 [IF]
0 0 IN/OUT
CODE MODE80X25
\ ( -- )
\ Sets display resolution 80x20
  0D003 # AX MOV
  10 INT
  RET
END-CODE
[THEN]

?DEFINE MODE64X18 [IF]
0 0 IN/OUT
CODE MODE64X18
\ ( -- )
\ Sets display resolution 64x18
  0D081 # AX MOV
  10 INT
  RET
END-CODE
[THEN]

?DEFINE MODE40X25 [IF]
0 0 IN/OUT
CODE MODE40X25
\ ( -- )
\ Sets display resolution 40x25
  0D083 # AX MOV
  10 INT
  RET
END-CODE
[THEN]

?DEFINE MODE40X16 [IF]
0 0 IN/OUT
CODE MODE40X16
\ ( -- )
\ Sets display resolution 40x16
  0D085 # AX MOV
  10 INT
  RET
END-CODE
[THEN]

?DEFINE PORT_INFRARED [IF]
0 0 IN/OUT
CODE PORT_INFRARED
\ ( -- )
\ Switches serial port to infrared
  4A01 # AX MOV
  15 INT
  4901 # AX MOV
  15 INT
  RET
END-CODE
[THEN]

?DEFINE PORT_WIRE [IF]
0 0 IN/OUT
CODE PORT_WIRE
\ ( -- )
\ Switches serial port to standard ("wired")
  4A01 # AX MOV
  15 INT
  4900 # AX MOV
  15 INT
  RET
END-CODE
[THEN]

?DEFINE PORT_OFF [IF]
0 0 IN/OUT
CODE PORT_OFF
\ ( -- )
\ Switches off serial port
  4A00 # AX MOV
  15 INT
  RET
END-CODE
[THEN]


?DEFINE SET_TIMER [IF]
1 0 IN/OUT
CODE SET_TIMER
\ ( sec -- )
\ par sec timeout in sec. (max. 3600)
\ Sets timeout
  0 # DX MOV
  0B6 # BX MOV
  BX MUL
  0A # BX MOV
  BX DIV
  AX BX MOV
  46 # AH MOV
  15 INT
  RET
END-CODE
[THEN]

?DEFINE (int15) [IF]
1 1 IN/OUT
CODE (int15)
\ help procedure
  15 INT
  RET
END-CODE
[THEN]


0A = [IF] DECIMAL [THEN]
