/* LKEY.C -- Key Input Routines

	Written March 1991 by Craig A. Finseth
	Copyright 1991,2,3,4 by Craig A. Finseth
*/

#include "loki.h"

static KEYCODE resmac_buf[MACROMAX] = { KEYNONE };
static KEYCODE *resmac_ptr;
static int resmac_count;
static int resmac_uarg = 0;
static FLAG resmac_incr = FALSE;

static KEYCODE mac_buf[MACROMAX] = { KEYNONE };
static KEYCODE *mac_ptr = mac_buf;
static KEYCODE *mac_menu_ptr = NULL;
static FLAG mac_record = FALSE;
static int mac_arg = 0;

static KEYCODE pushed = KEYNONE;

static char *str_ptr = NULL;
static int str_len = 0;

	/* holds last menus for backing up */
#define MENU_STACK_SIZE 5
static int menu_stack[MENU_STACK_SIZE];
static int menu_which[MENU_STACK_SIZE];
static int menu_stack_ptr = -1;

/* ------------------------------------------------------------ */

/* Ask a yes/no question in the echo line.  Return KEYQUIT, KEYABORT,
'Y', or 'N'. */

int
KAsk(int msgnum)
	{
	int chr;

	chr = KEYREGEN;
	for (;;) {
		DEcho(Res_String(NULL, RES_MSGS, msgnum));
		chr = ConvUpper(KGetChar());
		if (chr == KEYQUIT) {
			return(KEYQUIT);
			}
		else if (chr == KEYREGEN) {
			}
		else if (chr == KEYABORT || chr == ESC || chr == BEL) {
			return(KEYABORT);
			}
		else if (*sindex(Res_String(NULL, RES_MSGS, RES_YESSTRING),
				chr) != NUL) {
			return('Y');
			}
		else if (*sindex(Res_String(NULL, RES_MSGS, RES_NOSTRING),
				chr) != NUL) {
			return('N');
			}
		else	{
			TBell();
			}
		}
	}


/* ------------------------------------------------------------ */

/* begin defining keyboard macro */

void
KBegMac(void)
	{
	uarg = 0;
	if (mac_arg > 0) {
		DError(RES_MACROUSE);
		return;
		}
	mac_ptr = mac_buf;
	mac_menu_ptr = NULL;
	mac_record = TRUE;
	}


/* ------------------------------------------------------------ */

/* Do the ^: command. */

void
KColon(void)
	{
	char buf[COLMAX + 1];
	char resp[COLMAX + 1];
	char *cptr = buf;
	int num;
	KEYCODE chr;

	while ((chr = KGetChar()) != '`' && cptr < &buf[sizeof(buf) - 1]) {
		*cptr++ = chr;
		}
	*cptr = NUL;

	resmac_uarg = 0;	/* turn off buffered menu processing */

	while (KGetStr2(buf, resp, sizeof(resp)) == 'Y') {
		if (!SToN(resp, &num, 10)) {
			DError(RES_ERRNONNUM);
			}
		else	{
			isuarg = TRUE;
			uarg = num;
			resmac_uarg = 1;	/* menus must always be 1 */
			table = 0;
			key = KGetChar();
			TabDispatch(key, table);
			return;
			}
		}
	}


/* ------------------------------------------------------------ */

/* Echo msg if no char is typed within interval return true if msg
printed, else false */

FLAG
KDelayPrompt(int msgnum)
	{
	int cnt;

	for (cnt = 0; cnt < DELAYCOUNT; cnt++) {
		if (KIsKey() == 'Y') return(FALSE);
		}
	DEchoNM(Res_String(NULL, RES_MSGS, msgnum));
	return(TRUE);
	}


/* ------------------------------------------------------------ */

/* finish defining keyboard macro */

void
KEndMac(void)
	{
	uarg = 0;
	mac_record = FALSE;
	if (isuarg && mac_menu_ptr != NULL)
		mac_ptr = mac_menu_ptr - 1;
	else	mac_ptr -= 2;
	if (mac_ptr < mac_buf) mac_ptr = mac_buf;
	*mac_ptr = KEYNONE;
	}


/* ------------------------------------------------------------ */

/* do keyboard macro */

void
KFromMac(void)
	{
	if (mac_record) {
		DError(RES_MACROCREATE);
		uarg = 0;
		return;
		}
	mac_arg = uarg;
	mac_ptr = mac_buf;
	uarg = 0;
	}


/* ------------------------------------------------------------ */

/* Switch input to be from the supplied string. */

void
KFromStr(char *str, int len)
	{
	if (str == NULL || len <= 0) {
		str_len = 0;
		}
	else	{
		str_ptr = str;
		str_len = len;
		}
	}


/* ------------------------------------------------------------ */

/* Get a character and handle keyboard macros */

KEYCODE
KGetChar(void)
	{
	KEYCODE chr;

	if (pushed != KEYNONE) {
		chr = pushed;
		pushed = KEYNONE;
		return(chr);
		}
	if (str_len > 0) {
		str_len--;
		return(*str_ptr++);
		}
	while (resmac_uarg > 0) {
		chr = *resmac_ptr++;
		if (chr != KEYNONE) return(chr);
		resmac_uarg--;
		resmac_ptr = resmac_buf;
		if (resmac_incr) {
			DIncrDisplay();
			TForce();
			}
		resmac_incr = FALSE;
		}
	while (mac_arg > 0) {
		chr = *mac_ptr++;
		if (chr != KEYNONE) return(chr);
		mac_arg--;
		mac_ptr = mac_buf;
		DIncrDisplay();
		TForce();
		}
	TForce();
	chr = TGetKey();

	if (ESC_swap != ESC) {
		if (chr == ESC) chr = ESC_swap;
		else if (chr == ESC_swap) chr = ESC;
		}
	if (CTX_swap != ZCX) {
		if (chr == ZCX) chr = CTX_swap;
		else if (chr == CTX_swap) chr = ZCX;
		}
	KMacRec(chr);
	return(chr);
	}


/* ------------------------------------------------------------ */

/* Input a string argument. Return KEYQUIT, KEYABORT, or 'Y' (if ok). */

int
KGetStr(int msgnum, char *str, int len)
	{
	return(KGetStr2(Res_String(NULL, RES_MSGS, msgnum), str, len));
	}


/* ------------------------------------------------------------ */

/* Input a string argument. Return KEYQUIT, KEYABORT, or 'Y' (if ok). */

int
KGetStr2(char *msg, char *str, int len)
	{
	char sbuf[BIGBUFFSIZE];
	char keybuf[BIGBUFFSIZE];
	char buf[BIGBUFFSIZE];
	KEYCODE c;
	int amt;
	int retval;
	FLAG wastext = xprintf_get_text();

	xprintf_set_text(FALSE);
	*sbuf = NUL;
	c = KEYREGEN;
	for (retval = KEYNONE; retval == KEYNONE; ) {
		xsprintf(buf, "%s: %s", msg, sbuf);
		amt = strlen(sbuf);
		if (c == KEYREGEN || KIsKey() != 'Y') DEcho(buf);
		c = KGetChar();
		switch (c) {

		case KEYQUIT:
			retval = KEYQUIT;
			break;

		case KEYREGEN:
			break;

		case KEYABORT:
		case ESC:
		case BEL:
			retval = KEYABORT;
			break;

		case CR:
			retval = 'Y';
			break;

		case BS:
		case DEL:
			if (*sbuf != NUL) sbuf[amt - 1] = NUL;
			break;

		case ZCU:
			*sbuf = NUL;
			break;

		default:
			if (amt >= len - 1) {
				sbuf[amt - 1] = NUL;
				TBell();
				}

			if (c == ZCQ) c = KGetChar();
			sbuf[amt] = c;
			sbuf[amt + 1] = NUL;
			break;
			}
		}
	if (retval != KEYQUIT && retval != KEYABORT && *sbuf != NUL)
		xstrcpy(str, sbuf);
	xprintf_set_text(wastext);
	return(retval);
	}


/* ------------------------------------------------------------ */

/* Is key available from macro? */

char
KIsKey(void)
	{
	if (KMacIs() == 'Y') return('Y');
	return(TIsKey());
	}


/* ------------------------------------------------------------ */

/* Load and save the keyboard macro buffer. */

void
KLoadMac(void)
	{
	int cnt;

	cnt = Res_KeySeq(mac_buf,
		sizeof(mac_buf) / sizeof(mac_buf[0]) - 1,
		RES_KEYM, uarg);
	if (cnt < 0) {
		mac_buf[0] = KEYNONE;
		return;
		}
	mac_buf[cnt] = KEYNONE;
	mac_ptr = mac_buf;
	uarg = 0;
	}


/* ------------------------------------------------------------ */

/* Load and execute a macro from the resource file.  Overwrites the
menu macro. */

void
KMacDo(int table, int offset, FLAG incr)
	{
	resmac_uarg = uarg;
	resmac_count = Res_KeySeq(resmac_buf,
		sizeof(resmac_buf) / sizeof(resmac_buf[0]) - 1, table, offset);
	if (resmac_count < 0) {
		resmac_buf[0] = KEYNONE;
		return;
		}
	resmac_buf[resmac_count] = KEYNONE;
	resmac_ptr = resmac_buf;
	resmac_incr = incr;
	}


/* ------------------------------------------------------------ */

/* As KIsKey, but check for everything but terminal input. */

char
KMacIs(void)
	{
	if (pushed != KEYNONE) return('Y');
	if (str_len > 0) return('Y');
	if (resmac_uarg > 0 && *resmac_ptr != KEYNONE) return('Y');
	if (!mac_record && mac_arg > 0) return('Y');
	return('N');
	}


/* ------------------------------------------------------------ */

/* Return a pointer to the start of the keyboard macro. */

KEYCODE *
KMacPtr(void)
	{
	return(mac_buf);
	}


/* ------------------------------------------------------------ */

/* Record a macro keystroke. */

void
KMacRec(KEYCODE key)
	{
	if (mac_record) {
		*mac_ptr++ = key;
		if (mac_ptr > &mac_buf[MACROMAX - 1]) {
			DError(RES_MACROFULL);
			mac_ptr--;
			}
		*mac_ptr = KEYNONE;
		}
	}


/* ------------------------------------------------------------ */

/* Handle the specified menu. */

void
KMenu(int menu)
	{
	int cols[RESMAXENTRIES];
	int rows[RESMAXENTRIES];
	int kbuf[MACROMAX];
	char hot_chars[RESMAXENTRIES];
	char buf[(COLMAX + 1) * 2];
	KEYCODE chr;
	int which;
	int cntmenu;
	int number;
	int cnt;
	int w;
	int type;
	FLAG needdisp;
	int last_row = 0;
	int snap_row = 0;

	menu_stack_ptr = -1;
again:
	which = 0;
	needdisp = TRUE;
	if (menu == 0) {
		KMenuMac();
		menu = Res_Number(Res_Number(-1, -1) - 1, 0);
		float_row = 0;
		float_col = 0;
		menu_stack_ptr = 0;
		}
	else	{
		if (menu_stack_ptr < MENU_STACK_SIZE) menu_stack_ptr++;
		}
	menu_stack[menu_stack_ptr] = menu;
	menu_which[menu_stack_ptr] = 0;
	uarg = 0;
	isuarg = FALSE;

	chr = NUL;
	for (;;) {
		if (needdisp) {
			DClear(0, last_row);

			for (cnt = 0; cnt <= menu_stack_ptr; cnt++) {
				cntmenu = menu_stack[cnt];
				number = (Res_Number(cntmenu, -1) - 2) / 2;
				type = Res_Number(cntmenu, 1) & 0x0f;
				which = menu_which[cnt];
				DMenuSetup(rows, cols, hot_chars, cntmenu, 0,
					number);
				snap_row = TGetRow();
				DMenu(which, rows, cols);

				if (type == 0) {
					float_row = snap_row;
					float_col = 0;
					}
				else if (type == 1) {
					float_row = rows[which];
					float_col = cols[which];
					}
				else if (type == 2) {
					float_row = rows[which] - which - 1;
					float_col = cols[which] + 3;
					}
				}

			TSetPoint(snap_row, 0);
			while (TGetRow() <= last_row) {
				DLine(TGetRow());
				TSetPoint(TGetRow() + 1, 0);
				}
			last_row = snap_row;
			needdisp = FALSE;
			}
		DMenu(which, rows, cols);

		chr = ConvUpper(KGetChar());
		w = which;
		for (cnt = 0; cnt < number; cnt++) {
			if (chr == hot_chars[w]) {
				which = w;
				chr = CR;
				break;
				}
			if (++w >= number) w = 0;
			}
		menu_which[menu_stack_ptr] = which;
		switch (chr) {

		case KEYQUIT:
			MExit();
			return;
			/*break;*/

		case KEYABORT:
		case BEL:
		case ESC:
			if (menu_stack_ptr == 0) {
				DClear(0, last_row);
				for (cnt = 0; cnt <= last_row; cnt++) {
					DLine(cnt);
					TSetPoint(cnt, 0);
					}
				return;
				}
			menu = menu_stack[--menu_stack_ptr];
			which = menu_which[menu_stack_ptr];
			needdisp = TRUE;
			break;

		case CR:
			if (type == 0) {
				float_row = last_row;
				float_col = 0;
				}
			else if (type == 1) {
				float_row = rows[which];
				float_col = cols[which];
				}
			else if (type == 2) {
				float_row = rows[which] - which - 1;
				float_col = cols[which] + 3;
				}

			cnt = Res_KeySeq(kbuf,
				sizeof(kbuf) / sizeof(kbuf[0]) - 1,
				menu,
				which * 2 + 3);
			if (cnt == 2 && kbuf[0] == 256) {
				menu = kbuf[1];
				goto again;
				}
			else	{
				DClear(0, last_row);
				for (cnt = 0; cnt < last_row; cnt++) {
					DLine(cnt);
					TSetPoint(cnt, 0);
					}
				KMenuDo(menu, which * 2 + 3);
				return;
				}
			/*break;*/

		case KEYLEFT:
		case ZCB:
			if (type == 2) {
				KFromStr("\x1b\b\r", 3);
				}
			else	{
				if (--which < 0) which = number - 1;
				}
			break;

		case KEYUP:
		case ZCP:
		case DEL:
		case BS:
			if (--which < 0) which = number - 1;
			break;

		case KEYRIGHT:
		case ZCF:
			if (type == 2) {
				KFromStr("\x1b \r", 3);
				}
			else	{
				if (++which >= number) which = 0;
				}
			break;

		case KEYDOWN:
		case ZCN:
		case SP:
			if (++which >= number) which = 0;
			break;

		case FF:
		case KEYREGEN:
			DNewDisplay();
			DIncrDisplay();
			needdisp = TRUE;
			break;

		default:
			TBell();
			break;
			}
		}
	}


/* ------------------------------------------------------------ */

/* Execute the specified menu entry. */

void
KMenuDo(int menu, int entry)
	{
	uarg = 1;
	KMacDo(menu, entry, FALSE);
	}


/* ------------------------------------------------------------ */

/* Record the keyboard macro position. */

void
KMenuMac(void)
	{
	if (mac_record) mac_menu_ptr = mac_ptr;
	}


/* ------------------------------------------------------------ */

/* Push the supplied key into the input. */

void
KPush(KEYCODE key)
	{
	pushed = key;
	}


/* ------------------------------------------------------------ */

/* Internal routine to display current argument */

FLAG
KUArg(int targ)
	{
	int cnt;
	char buf[LINEBUFFSIZE];

	if (targ == 4) {
		for (cnt = 0; cnt < DELAYCOUNT; cnt++) {
			if (KIsKey() == 'Y') return(FALSE);
			}
		}
	xsprintf(buf, Res_String(NULL, RES_MSGS, RES_PROMPTARG), targ);
	DEchoNM(buf);
	return(TRUE);
	}


/* LKEY.C -- Key Input Routines */
