1 REM ***************** BAYESIAN PROBABILITIES ****************************
5 REM  IN THIS EXAMPLE THE FOLLOWING TWO RULES ARE USED
10 REM 10 IF INT=FALL
15 REM     THEN STOCK=RISE
20 REM 40 IF DOLLAR=RISE
25 REM     THEN INT=FALL
30 REM  THE BAYSIAN EQUATIONS ARE:
35 REM   FOR RULE 10
40 REM P(STOCK=RISE)=P(STOCK=RISE|INT=FALL)*P(INT=FALL)         (1)
45 REM              +P(STOCK=RISE|INT=NOT FALL)*P(INT=NOT FALL)
50 REM   FOR RULE 40
55 REM P(INT=FALL)=P(INT=FALL|DOLLAR=RISE)*P(DOLLAR=RISE)       (2)
60 REM            +P(INT=FALL|DOLLAR=NOT RISE)*P(DOLLAR=NOT RISE)
65 REM THE FOLLOWING ABREVIATIONS WILL BE USED
70 REM I1=P(INT=FALL)    I2=P(INT=NOT FALL)
75 REM I3=P(INT=FALL|DOLLAR=RISE)  I4=P(INT=FALL|DOLLAR=NOT RISE)
80 REM S1=P(STOCK=RISE)  S2=P(STOCK=RISE|INT=FALL)
85 REM S3=P(STOCK=RISE|INT=NOT FALL)
90 REM D1=P(DOLLAR=RISE)  D2=P(DOLLAR=NOT RISE)
95 REM RE-WRITING THE PROBABILITIES FOR THE RULES WE GET
100 REM S1=S2*I1+S3*I2      (3)
105 REM I1=I3*D1+I4*D2      (4)
110 REM ***************** INFERENCE MECHANISM ********************
115 REM FOR THIS EXAMPLE WE WANT TO DETERMINE THE PROBABILITY OF
120 REM  THE "STOCK=RISE". BY BACKWARD CHAINING WE COME TO RULE 10.
125 REM  THE CONDITION PART OF 10 HAS THE VARIABLE "INT". BY
130 REM  CONTINUING BACKWARD CHAINING WE COME TO RULE 40. THE CONDITION
135 REM  PART OF RULE 40 HAS THE VARIABLE "DOLLAR" WHICH IS NOT PART
140 REM  OF ANY OTHER RULE. THEREFORE THE USER INSTANTIATES EACH
145 REM  PROBABILITY VARIABLE IN EQUATION (3)
150 INPUT"WHAT IS THE PROBABILITY OF THE DOLLAR RISING";D1
155 D2=1-D1:REM THE PROBABILITY OF THE DOLLAR NOT RISING
160 PRINT"WHAT IS THE PROBABILITY OF INTEREST RATES FALLING IF THE"
165 INPUT" DOLLAR RISES";I3
170 PRINT"WHAT IS THE PROBABILITY OF INTEREST RATES FALLING IF THE"
175 INPUT" DOLLAR DOES NOT RISE";I4
180 I1=I3*D1+I4*D2
185 PRINT"*** THE PROBABILITY OF INTEREST RATES FALLING IS ";I1
190 INPUT"WHAT IS THE PROBABILITY OF STOCKS RISING IF INTEREST RATES FALL";S2
195 I2=1-I1:REM PROBABILITY OF INTEREST RATES NOT FALLING
200 PRINT"WHAT IS THE PROBABILITY OF STOCKS RISING IF INTEREST RATES"
205 INPUT" DO NOT FALL";S3
210 S1=S2*I1+S3*I2
215 PRINT"*** THE PROBABILITY OF THE STOCK MARKET RISING IS ";S1
220 STOP
