'ALPHANET Neural Network

DECLARE SUB pause (hitkey$, paused%)
DECLARE SUB printdots ()
DECLARE SUB dots (dot%())
DECLARE SUB quitit ()
DECLARE SUB logo ()

CLS



DEF SEG = &H40
x% = PEEK(16) AND &H30
IF x% = 32 THEN monitortype% = 0
IF x% = 48 THEN monitortype% = 1
'monitortype% =0 cga, monitor =1 hercules

IF monitortype% = 0 THEN CALL logo ELSE CALL quitit

innum% = 25
outnum% = 36
recnum% = 36
midnum% = (innum% + outnum% + 1) \ 2

DIM indata%(recnum%, innum% + 1)
DIM outdata%(recnum%, outnum%)
DIM midval%(midnum% + 1)
DIM outval%(outnum%)

DIM inwt&(innum% + 1, midnum%)
DIM outwt&(midnum% + 1, outnum%)
DIM outerr&(recnum%, outnum%)
DIM deltaout&(midnum% + 1, outnum%)
DIM deltasum&(midnum%)

DIM name$(recnum%)

DIM dot%(25)

FOR r% = 1 TO recnum%
indata%(r%, innum% + 1) = 10000
NEXT r%

midval%(midnum% + 1) = 10000

FOR r% = 1 TO recnum%

FOR i% = 1 TO innum%
READ indata%(r%, i%)
indata%(r%, i%) = indata%(r%, i%) * 10000
NEXT i%

outdata%(r%, r%) = 10000
READ name$(r%)

NEXT r%

RANDOMIZE TIMER

FOR i% = 1 TO innum% + 1
FOR m% = 1 TO midnum%
inwt&(i%, m%) = (2 * RND - 1) * 10000000
NEXT m%
NEXT i%

FOR m% = 1 TO midnum% + 1
FOR o% = 1 TO outnum%
outwt&(m%, o%) = (2 * RND - 1) * 10000000
NEXT o%
NEXT m%

SCREEN 0
COLOR 15, 1, 0
CLS
LOCATE 2, 14
PRINT "     NEURON EXPERT PROFESSIONAL II ALPHANET"
LOCATE 4, 5
PRINT "Copyright 1991 by Thinking Software, Inc.  All Rights Reserved."

LOCATE 7, 1
PRINT "        ͻ";
PRINT "                                                                     ";
PRINT "                                                                     ";
PRINT "                                                                     ";
PRINT "                                                                     ";
PRINT "                                                                     ";
PRINT "                                                                     ";
PRINT "                                                                     ";
PRINT "        ͼ";

LOCATE 14, 12
PRINT "SCANNER"

LOCATE 8, 25
PRINT " input"
LOCATE 9, 24
PRINT "NEURONS"
LOCATE 10, 23
PRINT "  output"

LOCATE 9, 33
PRINT "1234567890123456789012345"

CALL printdots
CALL dots(dot%())
CALL printdots

LOCATE 13, 33
FOR r% = 1 TO recnum%
PRINT name$(r%);
NEXT r%

LOCATE 12, 25
PRINT "TARGET"
LOCATE 14, 25
PRINT "OUTPUT"

LOCATE 9, 24
PRINT "PATTERN"

LOCATE 14, 12
PRINT "       "

LOCATE 17, 1
PRINT "                                            ͻ  "
PRINT "                                              pattern number           "
PRINT "                                              training cycle           "
PRINT "                                             true this cycle           "
PRINT "                                             true last cycle           "
PRINT "                                               average error           "
PRINT "                                               maximum error           ";
PRINT "                                            ͼ  ";

LOCATE 17, 1
PRINT "        ͻ"
PRINT "           target output            "
PRINT "          maximum output            "
PRINT "         connections/sec              "
PRINT "           input neurons     + 1 bias "
PRINT "          middle neurons     + 1 bias "
PRINT "          output neurons              "
PRINT "        ͼ";

COLOR 31
LOCATE 16, 9
PRINT "<<"
LOCATE 16, 71
PRINT ">>"
COLOR 15
LOCATE 16, 12
PRINT "TOGGLE [SPACEBAR] TO PAUSE.   PRESS ANY OTHER KEY TO QUIT.";

LOCATE 21, 28
PRINT innum%

LOCATE 22, 28
PRINT midnum%

LOCATE 23, 28
PRINT outnum%

DO
hitkey$ = INKEY$
LOOP WHILE hitkey$ <> ""

DO

sec1! = TIMER

cycle& = cycle& + 1

FOR r% = 1 TO recnum%

'**************************************feed forward 1******
'from input to middle layer
'**********************************************************
FOR m% = 1 TO midnum%
midsum& = 0
FOR i% = 1 TO innum% + 1
temp& = inwt&(i%, m%) \ 10000
temp& = temp& * indata%(r%, i%)
midsum& = midsum& + temp&
NEXT i%
midval%(m%) = CINT(10000 / (1 + EXP(-midsum& / 10000000)))
NEXT m%

'*************************************feed forward 2**********
'from middle layer to output layer
'*************************************************************
FOR o% = 1 TO outnum%
outsum& = 0
FOR m% = 1 TO midnum% + 1
temp& = outwt&(m%, o%) \ 10000
temp& = temp& * midval%(m%)
outsum& = outsum& + temp&
NEXT m%
outval%(o%) = CINT(10000 / (1 + EXP(-outsum& / 10000000)))

COLOR 15


outerr&(r%, o%) = outdata%(r%, o%) - outval%(o%)
NEXT o%

'*********************************back propagation 1
'from output layer to middle layer
'***************************************************
FOR o% = 1 TO outnum%
temp& = outerr&(r%, o%) * 4
temp& = temp& * outval%(o%)
temp& = temp& \ 10000
temp& = temp& * (10000 - outval%(o%))
pipe& = temp& \ 10000
FOR m% = 1 TO midnum% + 1
temp& = pipe& * midval%(m%)
temp& = temp& \ 10
outwt&(m%, o%) = outwt&(m%, o%) + temp&
deltaout&(m%, o%) = temp&
NEXT m%
NEXT o%

FOR m% = 1 TO midnum%
deltasum&(m%) = 0
FOR o% = 1 TO outnum%
deltasum&(m%) = deltasum&(m%) + deltaout&(m%, o%)
NEXT o%
NEXT m%

'*********************************back prop 2
'from middle layer to input layer
'********************************************
FOR m% = 1 TO midnum%
temp& = deltasum&(m%) \ 1000
temp& = temp& * midval%(m%)
temp& = temp& \ 10000
temp& = temp& * (10000 - midval%(m%))
pipe& = temp& \ 10000
FOR i% = 1 TO innum% + 1
temp& = pipe& * indata%(r%, i%)
temp& = temp& \ 10000
deltain& = temp& \ outnum% \ 10 * 4
inwt&(i%, m%) = inwt&(i%, m%) + deltain&
NEXT i%
NEXT m%

hitkey$ = INKEY$
IF hitkey$ = CHR$(32) THEN CALL pause(hitkey$, paused%)
IF hitkey$ <> "" THEN CALL quitit: END

LOCATE 19, 64
PRINT cycle&

LOCATE 18, 64
PRINT r%

CALL printdots

LOCATE 9, 13
FOR i% = 1 TO 5
IF indata%(r%, i%) = 10000 THEN PRINT "";  ELSE PRINT "";
NEXT i%

LOCATE 10, 13
FOR i% = 6 TO 10
IF indata%(r%, i%) = 10000 THEN PRINT "";  ELSE PRINT "";
NEXT i%

LOCATE 11, 13
FOR i% = 11 TO 15
IF indata%(r%, i%) = 10000 THEN PRINT "";  ELSE PRINT "";
NEXT i%

LOCATE 12, 13
FOR i% = 16 TO 20
IF indata%(r%, i%) = 10000 THEN PRINT "";  ELSE PRINT "";
NEXT i%

LOCATE 13, 13
FOR i% = 21 TO 25
IF indata%(r%, i%) = 10000 THEN PRINT "";  ELSE PRINT "";
NEXT i%

COLOR 15

'this prints horizontal input pattern
FOR i% = 1 TO 25
LOCATE 8, 32 + i%
IF indata%(r%, i%) = 10000 THEN PRINT "";  ELSE PRINT "";
'LOCATE 10, 32 + o%
'here,joe
'IF outdata%(r%, o%) = max%(r%) THEN PRINT "";  ELSE PRINT "";
NEXT i%

LOCATE 12, 32 + lastr%
COLOR 1
PRINT CHR$(0)
LOCATE 12, 32 + r%
COLOR 15
'this prints input block above line of letters
PRINT ""
lastr% = r%

max% = 0
FOR o% = 1 TO outnum%
IF max% < outval%(o%) THEN big% = o%
IF max% < outval%(o%) THEN max% = outval%(o%)
NEXT o%

LOCATE 14, 32 + lastbig%
IF lastbig% <> big% THEN PRINT CHR$(0)


'this prints output block under letter line
LOCATE 14, 32 + big%
PRINT ""

lastbig% = big%


LOCATE 18, 38
PRINT name$(r%)
LOCATE 18, 29
PRINT USING "#.####"; outval%(r%) / 10000;

LOCATE 19, 38
PRINT name$(big%)
LOCATE 19, 29
PRINT USING "#.####"; max% / 10000

IF r% = big% THEN true% = true% + 1
LOCATE 20, 64
PRINT true%

LOCATE 11, 32 + r%
IF r% = big% THEN PRINT "" ELSE PRINT name$(big%)

NEXT r%

LOCATE 21, 64
PRINT true%
true% = 0

sumerr& = 0

FOR r% = 1 TO recnum%
FOR o% = 1 TO outnum%
sumerr& = sumerr& + ABS(outerr&(r%, o%))
NEXT o%
NEXT r%

avgerr! = sumerr& / recnum% / outnum% / 10000

max% = 0

FOR r% = 1 TO recnum%
FOR o% = 1 TO outnum%
IF max% < ABS(outerr&(r%, o%)) THEN max% = ABS(outerr&(r%, o%))
NEXT o%
NEXT r%

maxerr! = max% / 10000

LOCATE 22, 65
PRINT USING "#.####"; avgerr!

LOCATE 23, 65
PRINT USING "#.####"; maxerr!

LOCATE 16, 1
PRINT STRING$(80, 0)

sec2! = TIMER

LOCATE 20, 28
sec! = sec2! - sec1!
temp& = 1958
temp& = temp& * 36
temp& = CINT(temp& / sec!)
IF sec2! > sec1! AND paused% <> 1 THEN PRINT temp&
paused% = 0

LOOP

DATA 1,1,1,1,1
DATA 1,0,0,0,1
DATA 1,1,1,1,1
DATA 1,0,0,0,1
DATA 1,0,0,0,1
DATA "A"
DATA 1,1,1,1,0
DATA 1,0,0,0,1
DATA 1,1,1,1,0
DATA 1,0,0,0,1
DATA 1,1,1,1,0
DATA "B"
DATA 1,1,1,1,1
DATA 1,0,0,0,0
DATA 1,0,0,0,0
DATA 1,0,0,0,0
DATA 1,1,1,1,1
DATA "C"
DATA 1,1,1,1,0
DATA 1,0,0,0,1
DATA 1,0,0,0,1
DATA 1,0,0,0,1
DATA 1,1,1,1,0
DATA "D"
DATA 1,1,1,1,1
DATA 1,0,0,0,0
DATA 1,1,1,0,0
DATA 1,0,0,0,0
DATA 1,1,1,1,1
DATA "E"
DATA 1,1,1,1,1
DATA 1,0,0,0,0
DATA 1,1,1,0,0
DATA 1,0,0,0,0
DATA 1,0,0,0,0
DATA "F"
DATA 1,1,1,1,1
DATA 1,0,0,0,0
DATA 1,0,0,1,1
DATA 1,0,0,0,1
DATA 1,1,1,1,1
DATA "G"
DATA 1,0,0,0,1
DATA 1,0,0,0,1
DATA 1,1,1,1,1
DATA 1,0,0,0,1
DATA 1,0,0,0,1
DATA "H"
DATA 0,1,1,1,0
DATA 0,0,1,0,0
DATA 0,0,1,0,0
DATA 0,0,1,0,0
DATA 0,1,1,1,0
DATA "I"
DATA 0,1,1,1,0
DATA 0,0,1,0,0
DATA 0,0,1,0,0
DATA 1,0,1,0,0
DATA 1,1,1,0,0
DATA "J"
DATA 1,0,0,1,1
DATA 1,0,1,0,0
DATA 1,1,0,0,0
DATA 1,0,1,0,0
DATA 1,0,0,1,1
DATA "K"
DATA 1,0,0,0,0
DATA 1,0,0,0,0
DATA 1,0,0,0,0
DATA 1,0,0,0,0
DATA 1,1,1,1,1
DATA "L"
DATA 1,1,0,1,1
DATA 1,0,1,0,1
DATA 1,0,1,0,1
DATA 1,0,0,0,1
DATA 1,0,0,0,1
DATA "M"
DATA 1,0,0,0,1
DATA 1,1,0,0,1
DATA 1,0,1,0,1
DATA 1,0,0,1,1
DATA 1,0,0,0,1
DATA "N"
DATA 0,1,1,1,0
DATA 1,0,0,0,1
DATA 1,0,0,0,1
DATA 1,0,0,0,1
DATA 0,1,1,1,0
DATA "O"
DATA 1,1,1,1,1
DATA 1,0,0,0,1
DATA 1,1,1,1,1
DATA 1,0,0,0,0
DATA 1,0,0,0,0
DATA "P"
DATA 1,1,1,1,0
DATA 1,0,0,1,0
DATA 1,0,0,1,0
DATA 1,1,1,1,0
DATA 0,0,0,0,1
DATA "Q"
DATA 1,1,1,1,1
DATA 1,0,0,0,1
DATA 1,1,1,1,1
DATA 1,0,1,0,0
DATA 1,0,0,1,1
DATA "R"
DATA 0,1,1,1,1
DATA 1,0,0,0,0
DATA 0,1,1,1,0
DATA 0,0,0,0,1
DATA 1,1,1,1,0
DATA "S"
DATA 1,1,1,1,1
DATA 0,0,1,0,0
DATA 0,0,1,0,0
DATA 0,0,1,0,0
DATA 0,0,1,0,0
DATA "T"
DATA 1,0,0,0,1
DATA 1,0,0,0,1
DATA 1,0,0,0,1
DATA 1,0,0,0,1
DATA 1,1,1,1,1
DATA "U"
DATA 1,0,0,0,1
DATA 1,0,0,0,1
DATA 1,0,0,0,1
DATA 0,1,0,1,0
DATA 0,0,1,0,0
DATA "V"
DATA 1,0,0,0,1
DATA 1,0,0,0,1
DATA 1,0,1,0,1
DATA 1,0,1,0,1
DATA 1,1,0,1,1
DATA "W"
DATA 1,0,0,0,1
DATA 0,1,0,1,0
DATA 0,0,1,0,0
DATA 0,1,0,1,0
DATA 1,0,0,0,1
DATA "X"
DATA 1,0,0,0,1
DATA 0,1,0,1,0
DATA 0,0,1,0,0
DATA 0,0,1,0,0
DATA 0,0,1,0,0
DATA "Y"
DATA 1,1,1,1,1
DATA 0,0,0,1,0
DATA 0,0,1,0,0
DATA 0,1,0,0,0
DATA 1,1,1,1,1
DATA "Z"
DATA 1,1,1,1,1
DATA 1,0,0,1,1
DATA 1,0,1,0,1
DATA 1,1,0,0,1
DATA 1,1,1,1,1
DATA "0"
DATA 0,1,1,0,0
DATA 0,0,1,0,0
DATA 0,0,1,0,0
DATA 0,0,1,0,0
DATA 0,1,1,1,0
DATA "1"
DATA 1,1,1,1,1
DATA 0,0,0,0,1
DATA 1,1,1,1,1
DATA 1,0,0,0,0
DATA 1,1,1,1,1
DATA "2"
DATA 1,1,1,1,1
DATA 0,0,0,0,1
DATA 0,1,1,1,1
DATA 0,0,0,0,1
DATA 1,1,1,1,1
DATA "3"
DATA 1,0,0,0,1
DATA 1,0,0,0,1
DATA 1,1,1,1,1
DATA 0,0,0,0,1
DATA 0,0,0,0,1
DATA "4"
DATA 1,1,1,1,1
DATA 1,0,0,0,0
DATA 1,1,1,1,1
DATA 0,0,0,0,1
DATA 1,1,1,1,1
DATA "5"
DATA 1,0,0,0,0
DATA 1,0,0,0,0
DATA 1,1,1,1,1
DATA 1,0,0,0,1
DATA 1,1,1,1,1
DATA "6"
DATA 1,1,1,1,1
DATA 0,0,0,0,1
DATA 0,0,0,0,1
DATA 0,0,0,0,1
DATA 0,0,0,0,1
DATA "7"
DATA 1,1,1,1,1
DATA 1,0,0,0,1
DATA 1,1,1,1,1
DATA 1,0,0,0,1
DATA 1,1,1,1,1
DATA "8"
DATA 1,1,1,1,1
DATA 1,0,0,0,1
DATA 1,1,1,1,1
DATA 0,0,0,0,1
DATA 0,0,0,0,1
DATA "9"

'
SUB dots (dot%())

DO
hitkey$ = INKEY$
LOOP WHILE hitkey$ <> ""

LOCATE 19, 8
PRINT "THIS IS THE RELATIONSHIP BETWEEN THE SCANNER AND THE INPUT NEURONS"
LOCATE 22, 25
PRINT "(press any key to skip to training)"

FOR k% = 1 TO 25

FOR n% = 1 TO 25
dot%(n%) = 0
NEXT n%

dot%(k%) = 10000

LOCATE 9, 13
FOR i% = 1 TO 5
IF dot%(i%) = 10000 THEN PRINT "";  ELSE PRINT "";
NEXT i%

LOCATE 10, 13
FOR i% = 6 TO 10
IF dot%(i%) = 10000 THEN PRINT "";  ELSE PRINT "";
NEXT i%

LOCATE 11, 13
FOR i% = 11 TO 15
IF dot%(i%) = 10000 THEN PRINT "";  ELSE PRINT "";
NEXT i%

LOCATE 12, 13
FOR i% = 16 TO 20
IF dot%(i%) = 10000 THEN PRINT "";  ELSE PRINT "";
NEXT i%

LOCATE 13, 13
FOR i% = 21 TO 25
IF dot%(i%) = 10000 THEN PRINT "";  ELSE PRINT "";
NEXT i%

COLOR 15

FOR i% = 1 TO 25
LOCATE 8, 32 + i%
IF dot%(i%) = 10000 THEN PRINT "";  ELSE PRINT "";
NEXT i%

hitkey$ = INKEY$
IF hitkey$ <> "" THEN GOTO outofdots

SLEEP (1)

NEXT k%

outofdots:

END SUB

SUB logo

SHELL "view tsi"
END SUB

SUB pause (hitkey$, paused%)

hitkey$ = ""

DO WHILE hitkey$ = ""
hitkey$ = INKEY$
LOOP

IF hitkey$ = CHR$(32) THEN hitkey$ = ""

paused% = 1

END SUB

SUB printdots

LOCATE 9, 13: PRINT ""
LOCATE 10, 13: PRINT ""
LOCATE 11, 13: PRINT ""
LOCATE 12, 13: PRINT ""
LOCATE 13, 13: PRINT ""

LOCATE 8, 33
PRINT "";

END SUB

SUB quitit

 COLOR 15, 0, 0
 CLS
 COLOR 15, 1
 FOR x = 1 TO 15
 LOCATE 4 + x, 18
 PRINT "                                              "
 NEXT x

 LOCATE 5, 18
 PRINT CHR$(201);
 FOR x = 1 TO 44: PRINT CHR$(205); : NEXT x
 PRINT CHR$(187)

 FOR x = 1 TO 13
 LOCATE 5 + x, 18
 PRINT CHR$(186)
 LOCATE 5 + x, 63
 PRINT CHR$(186)
 NEXT x

 LOCATE 19, 18
 PRINT CHR$(200);
 FOR x = 1 TO 44: PRINT CHR$(205); : NEXT x
 PRINT CHR$(188)

 LOCATE 7, 24
 PRINT "THE NEURON EXPERT PROFESSIONAL II"
 LOCATE 8, 24
 PRINT "    ALPHANET NEURAL NETWORK"

 LOCATE 11, 26
 PRINT "     Thinking Software, Inc."
 LOCATE 13, 33
 PRINT "46-16 65th Place"
 LOCATE 15, 28
 PRINT "    Woodside, N.Y. 11377"
 LOCATE 17, 34

 DO
 hitkey$ = INKEY$
 LOOP WHILE hitkey$ <> ""

 DO
 KEYHIT$ = INKEY$
 LOOP WHILE KEYHIT$ = ""

 COLOR 15, 0, 0
 CLS

END SUB

