bat * Loading HELP and DOCUMENTATION part 2

*	       Written by F.Canova 10/5/83 through 01/15/90
*   (c) Copyright 1983 to 1995 by Seaware Corp. all rights reserved.
*	This batch file REQUIRES EBL PLUS for proper execution!

		 **** NOTE! NOTE! NOTE! NOTE! ****
 RAM	|* <-----Change 'RAM' to 'BIOS' if PC isn't 100% IBM Compatible!

 if %G = .goto. then %G = | goto -%F
 beep type Error! Begin by using BATDOC first!
 type This file is an overlay to BATDOC.
 exit

-opt0	 %F = opt0     | skip 3
-line0	 %F = line0    | skip 2
-line599  %F = line599 | skip 1
-line1404 %F = line1404
	%G = .goto.
	color 8f |type Loading part 1 ...
	leave
	batdoc

-header * Routine prints general purpose header for help text
	stack.purge			|*  remove any pre-typed keystrokes.
	%n = %i $ 1 ( %i # - 2 ) & . & ( %i $ ( %i # - 1 ) 2 ) |* extract section # from page #
	color( white on black )
	cls
	color( white on cyan  )
	window( 1, 1, 79, 3, Combo)
	begtype
 \%H				     Page \%n

\07    Press:  PGDN for next page,   PGUP for prev page,  HOME for main menu.
end
	color( white on black)
	colorchar ~ as color(yellow on black)
	window( 1, 5, 79, 25, Combo)
	return

-scroll * Routine accepts key for scrolling help text
	%e = 0
	inkey %k
	if %k = KEY("Ctrl-C") then goto -opt0
	if %k = KEY(Esc)  %i = 0      | goto -line0
	if %k = KEY(Home) %i = 0      | goto -line0
	if %k = KEY(Pgup) %i = %i - 1 | cls | %F = line%i | goto -%F
	if %k = KEY(Pgdn) %i = %i + 1 | cls | %F = line%i | goto -%F
	goto -scroll |* ignore any other key.

	* ROUTINE TO HAVE USER GIVE A COMMAND A TRY !!
	* %A = string which must match
-tryit
	begtype

  Enter your guess!  ;
end
-tryit.loop
	if .%a = . goto -tryit.solved.it |* end of string ?
	%b = %a $ 1 1		|* get 1st letter
	%a = %a $ 2		|* remove it from string
-tryit.retry
	inkey %k		  |* get a key.
	if %k = KEY(" ") type %b; | goto -tryit.loop
	if %k = KEY(ESC) type %b%a| goto -tryit.give.up
	if %k = %b type %k;	  | goto -tryit.loop
	beep goto -tryit.retry

-tryit.solved.it
	begtype


EXCELLENT !! - that's exactly it!

end
	read Press the  key to continue to next section.....
	return

-tryit.give.up
	begtype

That's the answer you needed! (You can "peek" at part of
the answer next time by pressing the space bar if you'd like.)

end
	read Press the  key to continue to next section.....
	return

-opt6
-line503 %i = 600
-line600 %H = "How to print" | call -header| begtype
  The simplest thing to for Extended Batch Language to do is to print text
on the display.  This is done by either of two commands, TYPE and BEGTYPE.

  The TYPE command can be used for something as simple as saying hello!
For example, just put this in a batch file...

	BAT * Hello example...
	TYPE "HELLO THERE"

  This is all that is needed.  This command can be typed directly from DOS
(this is called immediate mode) or be entered into a file such as
"TRIAL.BAT" (this is called direct execution mode).  To execute it as a BAT
program with the file, just type the file's name "TRIAL" from DOS and you
will see the results of the program "HELLO THERE" coming from BAT.

Note that all EBL batch programs start with the word "BAT" and an optional
comment. This is always needed. For simplicity, we won't show it much in
the upcoming examples, but using it is necessary to tell DOS that future
commands are understood by EBL-Plus.
end
    goto -scroll
-line601 call -header | begtype

  You can also put DOS variables into this command to display their
contents.  For example, if the "TRIAL.BAT" file contained the line:

	TYPE "HELLO THERE" %1 %2

  Then when we start the BAT program from DOS, we might enter:

	TRIAL COMPUTER USER

  DOS will automatically store the words after the program name into its
variables.  Therefore, in the TYPE command, we will see contents of these
variables on the screen.  The resulting message would be:

	HELLO THERE COMPUTER USER
end
	goto -scroll
-line602 call -header | begtype

  There is a second method of putting text onto the display.  This is with
the BEGTYPE command.  Although it will not display the contents of
variables, it is very useful for displaying large blocks of text, such as
menus.	For example, if the "TRIAL.BAT" file contains:

	BAT BEGTYPE
	This is a large block of text. It is useful for menus. Note
	that Upper/Lower case characters are displayed intact here.
	The block is always ended with "END" in the first column
	after the text finishes.
	END

  When executed, the "TRIAL.BAT" program will display:

	This is a large block of text. It is useful for menus. Note
	that Upper/Lower case characters are displayed intact here.
	The block is always ended with "END" in the first column
	after the text finishes.
end
	goto -scroll
-line603 call -header | begtype

The easiest way to add color to menus is to first use the COLORCHAR command
to make a character represent a color change. Then, every time that character
is used within the BEGTYPE block, future text will be highlighted with
the new color. A space will be added where each color change occurs.
This technique is useful for both BEGTYPE and TYPE commands.

    BAT * BEGTYPE color sample ...
    ColorChar @ as Color(Yellow)
    BEGTYPE
    @This@is highlighted
    End
    Type "So is@this!@"

and after running the EBL program we see...

     ~This~is highlighted
     So is~this!~
end
	goto -scroll
-line699 %i = 604
-line604 call -header | begtype

  There is an additional advantage to using BEGTYPE command.  This command
can also highlight text to the user.  This is done by using the form:
[\\hex] within the text block.

  For example if the text block contained \\0F within the text, the result
would be ~ High Intensity Text !  ~.

  By choosing different values, the screen attributes can be controlled to
create inverted video, blinking, underlined, and very colorful text.

  You can also display the contents of variables by using [\\%Var.name] in
the text block. For instance, if the variable %0 is to be printed, use \\%0
within the text after the BEGTYPE command.

  An additional command CLS can be used to clear the display before
printing data.	For instance, the combination "BAT CLS BEGTYPE" is quite
useful for printing menus and text such as this screen.
end
	goto -scroll
-line604
	begtype

	~NOW IT'S YOUR TURN !!!~


If the ~%4~ variable contains the word ~DAY~, what is the command to display
the words "~FUN DAY~" on the display?

end
	 %A = "TYPE FUN %4" | Call -tryit
-opt7
-line605  %i = 700
-line700 %H = "Reading things from user" | call -header | begtype
  In order to get input from the user, there are two available commands,
READ and INKEY.

  When the command word READ is seen in the batch file, an input line is
accepted from the user.  All function keys are assigned to the normal DOS
edit functions.  When ENTER is pressed, the input line is assigned to DOS
variables.

  Each word will be assigned in order to the variables indicated after the
READ command.  When there are no more variables after the READ command to
assign, the remainder of the response is thrown away.  If there are more
variables to be assigned after the READ command than there are words from
the user, these variables will be cleared out to a empty state.  For
example:

	READ Please enter your name ==> %1 %2

  This would prompt the user and wait for him to enter two words.  These
words will be saved in the %1 and %2 variables.
end
	 goto -scroll
-line701 call -header | begtype

  Note that there does not have to be any variables indicated after the
command READ.  In this case, EBL would wait for the enter key, throw away
any response, then continue to process the next batch file command.

end
	goto -scroll
-line702 call -header | begtype

  In the event that you wish to get a single keystroke from the user, the
INKEY command should be used.

  This command will wait for the user to enter a single key on the keyboard
and return its value in the optional variable.	This key can be not only
letters, but all function keys, control keys, etc.  For example:

	INKEY Press any key to continue... %0

  When the user presses a single key, that key is saved into the variable %0.

  If the key that is pressed is in the range of "!" to "z" (decimal 33 to
122) then the key saved to the optional variable. If you wish this key to be
echoed to the display, you must specifically use the TYPE command.

end
	 goto -scroll
-line799 %i = 703
-line703 call -header | begtype

  If the key is not in the above range, then the key will be converted to
the form "KEYxxx" where xxx is the hex value of the key.  Extended key
codes will be in the range KEY100 to KEY1FF and nonextended key codes will
be in the range KEY000 to KEY0FF.  Refer to Appendix G of the Basic manual
for a complete description of the various assignments of key codes.

  The character does not have to be assigned to a variable.  If the
variable name is not present following the command INKEY, the system will
wait for any key to be pressed from the user, and then continue processing.

end
	goto -scroll
-line704
	begtype

	~NOW IT'S YOUR TURN !!!~


  We wish to create a menu with several options.  At a "~=>~" prompt,
the user must enter a~single letter~to select his option.  What is
the command needed to request a single keystroke into the ~%4~
variable for option selection using the prompt above?

end
	 %A = "INKEY => %4" | call -tryit
-opt8	 %i = 800
-line800 %H = "Program Control" | call -header| begtype
  There are several ways of controlling the order of execution of a program
written with Extended Batch Language.  GOTO, CALL, RETURN, and IF are all
commands that do this.	The simplest is the GOTO command:

	GOTO -LABEL

  If this line is put into a ".BAT" file, then it will stop execution at
this line and resume at the line within the file which contains:

	-LABEL

  This is a unconditional branch.  If the label is not present within the
file, and error will result.  Note the minus (-) sign before the label
name. ~Labels must be preceded with a minus sign.~ This is done so
that EBL can tell the difference between a label and a command within the
language.
end
	goto -scroll
-line801 call -header | begtype

   A CALL command is similar to a GOTO command.  The primary difference is
that the line where the CALL command was is saved away.  Then a branch to a
label is done, just like the GOTO command.  Note that the CALL command can
be nested up to 31 levels.  When a RETURN command is found, the last line
that was saved is now restored.  Execution resumes at the line following
the original CALL command.

end
	goto -scroll
-line802 call -header | begtype
For example, if a program contains:

	    TYPE One
	   ~CALL -LABEL~
	   ~CALL -LABEL~
	    TYPE Four
	    EXIT
	-LABEL
	    TYPE Two
	    TYPE Three
	   ~RETURN~

  You will see on the display:
	One
	Two
	Three
	Two
	Three
	Four
end
	goto -scroll
-line803 call -header | begtype
  The final way to control the flow of an Extended Batch Language program
is to use an IF command.  The general form of this command is:

	IF _word_   _condition_   _word_   _operation_______


  Each word can be a fixed string of letters, or a variable, or a
combination of each.

  The conditions can be:

	<	less than
	>	greater than
	<>	not equal to
	=	equal to (case insensitive)
	==	exactly equal to (case sensitive)

  The operation can be any of the Extended Batch Language commands.
end
	 goto -scroll
-line899 %i = 804
-line804 call -header | begtype
  For example, all of the following IF statements will compare correctly
and execute their corresponding TYPE command.  The first two statements
will initialize variables used in the IF commands.

	%1 = ABC
	%2 =

	IF ABC = %1  TYPE The variable contains ABC.
	IF %1 = abc  TYPE This also matches.
	IF 0 <> 00   TYPE These are different lengths.
	IF 0 < 00    TYPE 0 has a smaller length.
	IF 456 > 123 TYPE Numerically, 456 is bigger.
	IF 456 < %1  TYPE ASCII value of 456 is smaller.
	IF AABCD = A%1D TYPE Token substitutions are made.
	IF %2 <> %1  TYPE Variables are different lengths.
	IF .%2 = .   TYPE This matches if var is empty.
	IF BOX = BOX IF DOG <> CAT TYPE Did multi-if compare.
	IF 1 + 2 = 3 TYPE Arithmetic results match.
end
	goto -scroll
-line805
    begtype

       ~NOW IT'S YOUR TURN !!!~


  We wish to make a series of tests on a menu option that a user entered.
It is saved in the variable~%4~.  What command is needed to test for
the letter "~A~"?

end
	 %A = "IF %4 = A" | call -tryit
-opt9	 %i = 900
-line900 %H = "KEYBOARD STACK" | call -header| begtype
  There is a method within the EBL language for answering questions from
programs without operator intervention.  This is done by a "keyboard
stack".  By entering data into the stack, you will essentially be entering
data through your keyboard when any program requests it.  In this way, a
batch file can now answer questions programs may have by 'typing' them for
the user.

  The keyboard stack operates in a "first-in first-out" basis.  That is,
the first line of text put into the stack will be the first seen by the
program when it reads the keyboard.  The second line entered will be the
second seen by the program, and so on.	As long as there is text remaining
on the stack, ALL requests for data from the keyboard will actually come
from the stack.  Once the stack has been emptied by the program, data will
then come from the keyboard as usual.

  There are two commands which store data into the stack, STACK and
BEGSTACK. Here's some more about them.....
end
	 goto -scroll
-line901 call -header | begtype
  The STACK command is very much like the previously mentioned TYPE
command.  Instead of displaying to the screen, it will "push" data into the
keyboard stack area.  When any program is ready to accept information from
the keyboard, the parameters after the STACK command will be used as input.
For example:

	* This program will issue remarks to DOS.
	%1 = HELLO
	STACK REM THIS IS A REMARK FOR DOS
	STACK REM VARIABLE %%1 = %1

When executed, the following will appear on the screen:

	A>REM THIS IS A REMARK FOR DOS

	A>REM VARIABLE %1 = HELLO
end
	 goto -scroll
-line902 call -header | begtype
  The second command used to stack data is BEGSTACK.  This command is
equivalent to BEGTYPE previously described.  It is useful for dumping large
amounts of data to the stack area.  Although no parameter substitution is
performed, there are several advantages to its use.

  First, if a line ends with the ";" (semicolon) character, a carriage
return will NOT be stacked.  Second, if "\\HEX" is used where HEX is a

number from 01 to FE, then this exact keyboard value will be stacked.  This
is useful for stacking special control characters and symbols.	Third, if
"\\00\\HEX" is used, an extended key code will be stacked.  This is useful
for stacking function keys and the like.  Refer to the Basic manual in
Appendix G under "Extended Codes".  Fourth, if \\FF\\HEX is used, the stack
will delay the keyboard characters from appearing to the program for HEX
number of CPU "ticks".  There are about 12 hex (18 decimal) ticks per
second in the CPU.  In all cases, the word HEX above represents a two digit
hexadecimal number. Finally, \\\\ can be used to stack a single backslash.

Some examples...
end
	 goto -scroll
-line903 call -header | begtype
Some examples of BEGSTACK command::

	BEGSTACK
	\\09 Will stack the tab key.
	This text will be stacked ;
		on one line!
	\\00\\3B Will stack an F1 key.
	\\\\ is seen as one backslash.
	\\FF\\24 will pause two seconds.
	END


Hint: Some programs remove keystrokes before accepting a critical key. In
some cases this can be avoided by using \\FF\\01 in the BEGSTACK command.
end
	 goto -scroll
-line904 call -header | begtype
Note that in the above examples, the STACK or BEGSTACK commands always are
~before~ the command or program that will be using the keystrokes. An
example of this order is:

	BEGSTACK
	<<keystroke values needed by the program>>
	END
	<<program that will be controlled by the stack>>

An example of using the stack with the COPY command within DOS would be:

	BEGSTACK
	This text will be given to the copy command.
	\\00\\3B An F1 key ends the copy.
	END
	COPY CON: result.txt

end
	 goto -scroll
-line905 call -header | begtype
There are also three control commands which are associated with the stack:

STACK.OFF     - Redirects data to come directly from
		the physical keyboard. Does not remove
		any data in the stack.

STACK.ON      - Directs data to come from the stack.
		This is the default.

STACK.PURGE   - Removes any data from the stack and
		keyboard buffers which are pending.
end
	goto -scroll
-line999 %i = 906
-line906
    begtype

       ~NOW IT'S YOUR TURN !!!~


  From our menu, we wish to start up a communications program and
automatically dial a phone number with a smartmodem.  The communications
program we have will take what is typed on the keyboard and send it to the
modem.	The command needed for the modem to dial our phone is
"~ATD12~" .  What Extended Batch Language command will force the
communication program to dial this modem command?

end
	%A = "STACK ATD12" | call -tryit
-opt10	%i = 1000
-line1000 %H = "GETTING RESULTS!" | call -header | begtype
  The results of programs often need to be known so that some action can
take place after the program ends.

  When the command word READSCRN is seen in the batch file, a line of text
is read from the display screen into variables.  Having the ability to read
text from the display can be useful for determining the result of another
program, or making a query for some system status which would not normally
be available within a batch file.  For example, by reading a directory from
the screen, a series of files can be submitted to the macro assembler.
Once the assembly is completed, the status can be read from the screen to
determine if there were errors which would stop the link step.	Virtually
any message which a program can generate can be used as feedback to a batch
file by using READSCRN.
end
	  goto -scroll
-line1001 call -header | begtype
  Its operation is very much like the READ command except for the fact that
the information which is being read is coming from the display screen and
not the keyboard.  Like the READ command, the text from the screen is
tokenized (separated at word boundaries and assigned to variables).  The
return code %R will be reflect the line number on the display that was
read.  This number will be in the range of 1 to 25 for the top to bottom
lines respectively. Once a line is read, this command will be set to read
the previous line. Repeated READSCRN commands will read UP the display!

For example:
	CLS
	TYPE HELLO THERE
	READSCRN %A %B %C

After execution:
	%A contains HELLO
	%B contains THERE
	%C contains nothing, it is empty.
	%R (return code) contains 1, the line number that was read.
end
	  goto -scroll
-line1099 %i = 1002
-line1002
    begtype

       ~NOW IT'S YOUR TURN !!!~


  From our menu, we have started the IBM Macro Assembler program.  We know
that when this program ends, it will display a number representing the
number of errors that were found.  We want to make sure that this number is
zero before continuing to the LINK program.  If we save this number in the
variable~%A~, what is the command to read the assembler result from
the display?

end
	  %A = "READSCRN %A" | call -tryit
-opt11	  %i = 1100
-line1100 %H = ASSIGNMENTS	 | call -header| begtype
  If the first character in the command is a '%' (Percent sign), then it is
considered to be an assignment statement.  The first variable cannot be any
predefined variable (such as %R or %%), but may be any of the other
variables %0 to %9 and %A to %O.  If a DOS command is later executed and
uses one of the variables %0 to %9, it will be properly replaced with the
contents of that variable.

The first assignment token, the operator, and the final tokens are optional.
The assignment statement must appear in one of the following forms:

~[var] = ~- create empty variable
~[var] = [string]	      ~- simple assignment
~[var] = [number] + [number]  ~- addition
~[var] = [number] - [number]  ~- subtraction
~[var] = [number] * [number]  ~- multiplication
~[var] = [number] / [number]  ~- division
~[var] = [number] % [number]  ~- remainder
~[var] = [string] #	      ~- string length
~[var] = [string] $ [index] [length] ~- create substring (like MID$ in BASIC)
end
	goto -scroll
-line1199 %i = 1101
-line1101 call -header | begtype
 ~[var]~ - A DOS variable or global user variable %0 to %9 and %A to
%O.  It may not be a predefined variable.

 ~[string]~ - Any valid token.	Letters, numbers, any variable, or any
combination there of.  123, ABC, and 987%J4SF are all valid strings.

  ~[number]~ - Any token with a numeric result in the range of  2**64.
For example (if %A contains 34) the three numbers 98, %A, and 12%A5
(equivalent to 12345) would all be valid numbers.

  ~[index]~ - Same restrictions as [number] above except that an
[index] above 16 is meaningless and is equivalent to the number 16.

  ~[length]~ - Same restrictions as [number] above except that a
[length] above 15 is meaningless and is equivalent to the number 15.  Note
that [length] is optional and has a default value of 15.

end
    goto -scroll
-line1102
    begtype

       ~NOW IT'S YOUR TURN !!!~


  We wish to count the number of times that a user has used a certain .BAT
program.  We will keep this count in the global user variable~%A~
which will stay active even BETWEEN batch file execution.  What is the
command needed to increase the value in this variable by one?

end
	%A = "%A = %A + 1" | call -tryit
-opt12	%i = 1200
-line1103
-line1299 %i = 1200
-line1200 %H = "DEBUGGING AIDS" | call -header| begtype
As an aid in debugging, the TRACE(ALL) function turns on a special flag that
causes each line in the EBL program to be printed as it is executed.  Three
'+' (plus) symbols will precede the EBL statement which is printed out as an
aid.  The trace can be turned off at any time by the TRACE(OFF) function.
The various types of traces that can be done are:

	~Trace(Off)~	   Turn off program tracing
	~Trace(Commands)~  Trace only DOS commands
	~Trace(All)~	   Trace all EBL and DOS commands
	~Trace(Results)~   Trace commands and expression results
	~Trace(Intermed)~  Trace commands and intermediate results

A trace can be active during DOS commands within the EBL program.  In
addition, trace can be enabled/disabled at any time, even in immediate mode.
Once enabled, it will remain in effect until the TRACE(OFF) command is
executed.  Errors, execution of other EBL language files, and even executing
DOS commands will not change the trace mode.
end
	  goto -scroll
-opt13
-line1201 %i = 1300
-line1300 %H = "Functions" | call -header| begtype

Built into EBL Plus is a large set of useful functions.  These functions
are helpful when writing advanced EBL programs.  In general, you could
write almost all of your EBL programs without using these functions.
Occasionally, there may be some special need for a unique operation that is
not a part of the standard commands built into Extended Batch Language.
For these advanced needs, we have written a rich library of Extended
Functions.

end
	goto -scroll
-line1301 call -header | begtype
~The following 45 functions are built into BAT.COM.~ If you include
the various attributes each can have, there are thousands of combinations.

  CENTER()	 EDIT() 	LOWER()        SEEK()	      VERSION()
  CHDIR()	 EXIST()	MKDIR()        SELECT()       WHATFUNC()
  CHARIN()	 FIELD()	NOT()	       SPACE()	      WINDOW()
  COLOR()	 FIND() 	PEEK()	       STRIP()	      WORD()
  COPIES()	 GETDIR()	PLAY()	       SUBWORD()      WORDS()
  CURSOR.COL()	 INT86()	POKE()	       TIME()
  CURSOR.ROW()	 KEY()		RANDOM()       TRACE()
  DATE()	 KEYPRESSED()	REVERSE()      TRANSLATE()
  DELWORD()	 LEFT() 	RIGHT()        UPPER()
  DIR() 	 LENGTH()	RMDIR()        VERIFY()

end
	goto -scroll
-line1302 call -header | begtype
These functions can be used any place a variable or other values
can be used.  For instance, they can be used in an expression:

	%A = LEFT( %B, 8 )

They can be used in a condition statement:

	If KEYPRESSED() then goto -Had.Key

Or they can be used in combination with each other:

	Type "The hour is now:" CENTER( TIME(), 20, "-" )

In general, external functions can be very powerful additions to Extended
Batch Language.  Registered users receive details of how to add their own
custom additions using external functions.
end
	  goto -scroll
-line1303 call -header | begtype

EBL functions are organized into four categories....

~CONSOLE~

  CHARIN()
  COLOR( names )
  CURSOR.ROW()
  CURSOR.COL()
  EDIT( field color )
  FIELD( field number {,field color} )
  KEY( name )
  KEYPRESSED()
  PLAY( notes )
  SELECT( Field Color {,Bar Color {,Arrow}} )
  WINDOW( X1, Y1, X2, Y2 {, Kind } )
end
	goto  -scroll
-line1304  call   -header  |  begtype
~STRING~

  CENTER( string, i {, pad} )
  COPIES( string, n )
  DELWORD( string, n {, length} )
  FIND( sentence, phrase )
  LEFT( string, i {, pad} )
  LENGTH( string )
  LOWER( string )
  REVERSE( string )
  RIGHT( string, i {,pad} )
  SPACE( string, n {, pad} )
  STRIP( string {, type {, char}} )
  SUBWORD( string, n {, length} )
  UPPER( string )
  VERIFY( string, reference )
  WORD( string, n )
  WORDS( string )
end
	goto  -scroll
-line1305  call  -header  |   begtype
~SYSTEM~

  CHDIR( directory )
  DATE( {type} )
  DIR( file {,type {,attribute}} )
  EXIST( file )
  GETDIR()
  INT86( intr, regs )
  MKDIR( directory )
  PEEK( locn )
  POKE( locn, value )
  REBOOT
  RMDIR( directory )
  SEEK( r/w, posn )
  TIME( {type} )
end
	goto -scroll
-line1306 call -header | begtype

~EBL/CONTROL~

  NOT( expression )
  TRACE( type )
  VERSION()
  WHATFUNC()


end
	goto -scroll
-opt14
-line1307 %H = "CONSOLE FUNCTIONS"| %i = 1307| call -header | begtype
~CONSOLE FUNCTIONS~

The console group  of functions interact  with the screen and keyboard that
the user sees. Functions can be used anywhere  other values or	expressions
are  used.  For  example,  in  an  assignment  statement,  an  IF  or  TYPE
statement, and so on.

~CHARIN()~  This function  waits for a single  keystroke then  returns	its
     value.  If a function key is pressed, the entire key name is returned.
     The key is not  echoed to the screen.

	     if CHARIN() = "F3" then goto -showhelp

~COLOR( color name {{on} color name} )~  This function converts one or more
     color names  into its corresponding hexadecimal attribute.  The result
     can be used in menus within the BEGTYPE command.  If used by itself as
     a keyword, this function will set the default color of any future text
     to be printed with either the TYPE or BEGTYPE commands.
	     COLOR( White On Cyan )
end
	goto -scroll
-line1308 call -header | begtype
~CURSOR.ROW()

CURSOR.COL()~  This  function  returns the cursor's current  row  or column
     position.	It  is useful when  you want  to  hold	the  current cursor
     position so that you can use LOCATE to  return  the cursor to the same
     point.

	     %0 = cursor.row()

~EDIT( field color )~  This  function  allows  any text on the screen to be
     edited interactively.  The  screen  is  first set with  the fields  or
     areas to edit, marked with a field color.	Then the EDIT() function is
     used to allow the user to	interactively  modify and create text right
     on  the screen.  Only colored areas on the screen that match the field
     color  can  be  modified.	The name of  the  exit key pressed  will be
     returned as the value of this function.

       EDIT( COLOR( Yellow on Cyan ))

end
	goto -scroll
-line1309 call -header | begtype
~FIELD( field number {,field color} )~	This   function  returns  the  text
     contents of a screen field.  Field  numbers  are  counted from the top
     left  of  the screen sequentially to  the	bottom	right.	Fields	are
     identified by a specific field color  on the display.

	     %A = FIELD( 1 , color( Yellow on Cyan))

~KEY( name )~  When used outside  an expression, this function will put the
     named key on the keyboard stack.

	     KEY(PgUp)

     If the name is plain text and not a key name, then the plain text will
     be stacked instead.

	     KEY("Any Words...")

     If "KEY(PAUSE)" is used outside an expression, then this function will
     put a one second delay on the keyboard stack.
end
	goto -scroll
-line1310 call -header | begtype

~KEYPRESSED()~ This function returns the letter "F" if the keyboard has not
     been  pressed, and the letter "T"  if  any key has  been pressed.  The
     result is	obtained  by calling the  operating  system console  status
     routine.

	     if keypressed() then goto -checkit

~PLAY( notes )~  This  function  converts   a  list  of   notes   into	the
     corresponding sound.  Up  to 50 notes and	rests can  be played in the
     background.  The notes  available	are the same as in BASIC.  To avoid
     confusion, strings of notes should always be enclosed by quotes.
	 %A = "GFE-FGGG"
	 PLAY( "T200" %A "P FFFP G>CCP <" %A "GFFGFE-..." )
end
	goto -scroll
-line1311 call -header | begtype
~SELECT( Field Color {,Bar Color {,Arrow}} )~ This function allows the user
     to select one item from a list  of several items using  the cursor.  A
     moving bar indicates  which item  can be  selected.  The position, and
     length of	the bar, is limited to the areas on the  screen  using	the
     field color.  The default bar color is inverted video.  The arrow keys
     can move  the bar in any  direction.  Any Function Key, ESC,  or Enter
     key will exit the function.  This function returns the name of the key
     used to exit. The value in %R indicates the field number selected.
	     colorchar * as color(cyan)
	     cls type "Select option *one* or *two*"
	     select( color(cyan) )

~WINDOW( X1, Y1, X2, Y2 {, Kind } )~ This function draws a rectangular area
     on  the display.  The area is defined  by the X1, Y1  location of	the
     top left corner, and the X2, Y2  location	of the bottom right corner.
     The color used is based on the last COLOR command executed.  There are
     several types  of	borders available.  Only  the  first  letter in the
     border  name is required.	Kinds  are: Blank,  Combo, Highlighted, 3D,
     Double line, Single line.
end
	goto -scroll
-opt15
-line1312 %H = "STRING FUNCTIONS"| %i = 1312| call -header | begtype

~STRING FUNCTIONS~

The string group of functions perform various operations on characters.  As
with other functions, they can be used anywhere other values or expressions
are  used.  For  example,  in  an  assignment  statement,  an  IF  or  TYPE
statement, and so on.

~CENTER( string, length {,pad} )~
~CENTRE( string, length {,pad} )~ This	function returns a character string
     of  length  length.  The  center-most  characters	of the	string	are
     returned.	The default pad at both sides is a blank.

	 CENTER( "ABC", 8, '-' )                   ==  '--ABC---'

~COPIES( string, n )~  This function returns n copies of the string.

	 COPIES('Two-',2)                    ==  'Two-Two-'
end
	goto -scroll
-line1313 call -header | begtype
~DELWORD( string, n {, length} )~
     This function removes a portion of the string starting
     at the nth word. A length amount of words separated
     by blanks will be removed. If length is not used, it will
     remove all remaining words in the string.
	 DELWORD('now is the time',2,2)  == 'now time'

~FIND( sentence, phrase )~
     This function finds the phrase string within the
     sentence string. If found, it will return the position
     of the first matching word in the sentence. If not found,
     it will return 0.
	 FIND('now is the  time','the time') ==  3

~LEFT( string, length {,pad} )~ This function returns a character string of
     length  length.  The left-most  characters of  the  input	string	are
     returned.
	 LEFT( "ABC", 8, '-' )               == 'ABC-----'
end
	goto -scroll
-line1314 call -header | begtype

~LENGTH(string)~   This  function returns the  number  of  characters in the
	 'string'.
	 LENGTH('abcdefgh')                  == 8

~LOWER(string)~  This  function  returns   a   character   string  with  all
     characters converted to lower case.
	 LOWER("abcDEF")                     == abcdef

~REVERSE( string )~  This  function  will  reverse  the  letters  within  the
     string end for end. The reversed string is returned to the caller.

	 REVERSE('Abc defg')  ==  'gfed cbA'

~RIGHT(string,length{,pad})~  This  function  returns  a character  string of
     length length.  The right-most  characters  of  the  input string	are
     returned.
	 RIGHT("ABC",8,'-')                  ==  '-----ABC'
end
	goto -scroll
-line1315 call -header | begtype

~SPACE( string, {n {, pad}} )~	This  function changes the  spacing  of the
     string to be  n blanks between each word. If n  is  0, then all blanks
     are removed.
	 SPACE(' abc def  ',1,'-')   == 'abc-def'

~STRIP( string {,type {,char}} )~ This function removes a character from the
     sides of  the  string.  The  type	parameter  may be "B"  (Both),  "L"
     (Leading), or "T" (Trailing) for  the three  types  of  striping.  The
     default  character to  be striped from  the sides of the string  is  a
     blank.
	 STRIP( "   AB C   ")                ==  'AB C'
	 STRIP( 00012.700, T, '0' )          ==  '00012.7'

~SUBWORD( string, n {, length} )~  This  function  returns a portion of the
     string  starting  from  the  nth  word  for  length   words  long.  If
     length is omitted, the remainder of the string is returned.
	 SUBWORD("now is the time",2,2)   == 'is the'
end
	goto -scroll
-line1316 call -header | begtype

~UPPER( string )~  This   function  returns  a	character string  with	all
     characters converted to upper case.
	 UPPER("ABC/def/Ghi")   ==   'ABC/DEF/GHI'

~VERIFY( string, reference )~  This  function  verifies that the  string is
     composed  only  of  characters in	the  reference	string.  The  first
     non-matching   character  position  in  string  is  returned.  If	all
     characters in the string are in the reference, then 0 is returned.
	 VERIFY( "$12.95","0123456789.$")    ==  0
	 VERIFY( "$12xxx","0123456789.$")    ==  4

~WORD( string, n )~ This function returns the nth blank delimited word from
     the string.
	 WORD('Powerful new EBL features',2) ==  'new'
end
	goto -scroll
-line1317 call -header | begtype

~WORDS( string )~  This function returns the number of blank delimited words
     within the string.

	 WORDS(' ')                          ==  0
	 WORDS('Power house capability')     ==  3

end
	goto -scroll
-opt16
-line1318 %H = "SYSTEM FUNCTIONS"| %i = 1318| call -header | begtype
~SYSTEM FUNCTIONS~

The System  Functions  are  use  to  get  the status of  the  computer, and
performs various operations on the files of a hard disk or floppy disk.  As
with other functions, they can be used anywhere other values or expressions
are  used.  For  example,  in  an  assignment  statement,  an  IF  or  TYPE
statement, and so on.

~CHDIR( directory_name )~  The current sub-directory is  changed to the new
     directory_name.  CHDIR() returns no value.

	 CHDIR("c:\\newdisk")

~DATE( {type} )~ This function returns a  character string representing the
     system date.  The default	DATE() function without a type	will return
     the system date  in  the format  'dd Mmm yyyy'.  For example, it would
     return a date in the form '2 Sep 1989'.  Other forms are: 'C' Century,
     'D'  Days,  'E'  European,  'J'  Julian,  'M'  Month, 'N'  Normal, 'O'
     Ordered, 'S' Standard, 'U' USA, and 'W' Weekday.
end
	goto -scroll
-line1319 call -header | begtype

~DIR( filename {,type {,attribute}} )~ This  function is a  superset of the
     EXIST() function.	It  can return	any information  about the files on
     the disk.	The type  and attribute  portions are optional.  If neither
     are used, the result is identical to the EXIST() function.  A  summary
     of options follows.  Results  shown  are typical but may  be different
     than   your  results.  The  following  types  of  information  can  be
     returned:
     ~DIR( filename )  ~     - See if the filename exists
     ~DIR( filename, I)~     - Index to next matching file name
     ~DIR( filename, A)~     - file Attributes
     ~DIR( filename, D)~     - file Date (attribute is optional, see DATE()
     ~DIR( filename, T)~     - file Time (attribute is optional, see TIME()
     ~DIR( filename, S)~     - file Size
     ~DIR( filename, N)~     - file Name
     ~DIR( filename, P)~     - Position of file within DOS directory
     ~DIR( position, R)~     - Return to Index position
end
	goto -scroll
-line1320 call -header | begtype
~EXIST( file )~ EXIST(filename)  determines  if a file is in the  directory.
     It returns the file name if it does exist, and a NULL value if it does
     not exist.  The file  name can contain a  complete  path  and the wild
     characters * or ?.  It is easily combined with the IF command like:

	 IF EXIST("FILE.TXT") THEN ..statement..

~GETDIR()~The current sub-directory name of  the default drive is returned.
     The name  will be a  valid,  fully qualified,  path name including the
     current default drive.  For  example, if the current  directory is the
     root directory on drive C, a "C:\\" will be returned.

end
	goto -scroll
-line1321 call -header | begtype

~INT86( intr, regs )~ This function  executes  an  8086 software interrupt.
     CAUTION!  The INT86()  function  is for advanced programming functions
     only.  The  intr value is a hex number from 00 to FF of  the  software
     interrupt to be executed.	The regs  value is a series  of  hex values
     for AX BX CX DX SI DI DS and ES in that order.  They  are	word values
     given in hex and  separated by  blanks. The notation  %%A	may also be
     used  to indicate the  address  of the variable %A. This function will
     return the values of AX  BX CX DX SI DI DS ES and	FLAGS in that order
     after the interrupt has executed.

	 %A = Hello$
	 INT86( 21 0900 0 0 %%A 0 0 %%A )

~MKDIR(directory_name)~  A new sub-directory is created with this function.
     This new  name  can include a  default drive name.  The directory name
     can not exceed 63 characters.

end
	goto -scroll
-line1322 call -header | begtype

~PEEK(location)~  This function  returns  a  byte of  memory,  in  hex,  at
     location.	The  hex  value returned  is  always  two  characters.	The
     location  is a two part hex value and  contains both a segment  and an
     offset,  separated   by  a  colon	":".   For  example,  the  location
     "0040:01A4"  would represent  segment 0040  and  offset 01A4.  If  the
     segment is not present, it is assumed to be zero.	If both segment and
     offset are supplied, then the colon ':' between them is required.

~POKE(location,value)~	This  function	writes	 a   byte   of	memory	at
     location  with the contents of value.  No	value is returned from this
     function after the  write.  Location  is  a  two  part hex  value	and
     contains  both a segment and  an offset separated by a colon ":".  For
     example,  the location "0040:01A4" would  represent  segment 0040  and
     offset 01A4.  If the segment is not present, it is assumed to be zero.
     If  both segment and offset are supplied, then  the colon ':'  between
     them is required.

end
	goto -scroll
-line1323 call -header | begtype

~REBOOT~ This  command initializes the PC  by  starting the bootstrap (IPL)
     procedure.  This  is  equivalent	to  pressing  CTRL-ALT-DEL  on	the
     keyboard.	Once  this command  is executed,  all programs are  removed
     from memory  (including EBL)  and the  system will reload	from either
     diskette or hard disk.  If the system  is a  PC compatible, the memory
     test will be avoided which will speed up the re-booting process.

~RMDIR(directory_name)~   An empty sub-directory   is  removed	with   this
     function.	The name can  include  a default drive name.  The directory
     name cannot exceed 63 characters.	DOS requires that the sub-directory
     be  completely empty of both files and other sub-directories before it
     can be removed.
end
	goto -scroll
-line1324 call -header | begtype
~SEEK( r/w {,position} )~  This function can  be  used to find the location
     within a file that is are being read or  written.	It can also be used
     to change that  position.	This  can  be  used to	create	files  with
     special formats, or to allow files to be randomly accessed.

     The first parameter r/w is required.  It may be either "<" or "R" for
     the file currently being read, or ">" or "W" for the file being written.

     If  this  is  the only parameter  supplied,  the  SEEK() function will
     return the current I/O position in  the  file.  This  value  will be a
     decimal offset from the beginning of the file.

     If position  is supplied, the file position will  be moved to this new
     location.	The  position  must  be  a  positive  decimal  number.
     If position  is 'EOF', the file position  will be moved to the  end of
     the file.
		BAT * Show file size
		<TEST.FIL
		TYPE "File contains" SEEK(R,EOF) "bytes"
end
	goto -scroll
-line1325 call -header | begtype

~TIME( {type} )~  This function returns a character string representing the
     system time.  In the case of the  TIME() function without a type,	the
     time returned will be in the default 24-hour clock format	'hh:mm:ss'.
     For example, it might be '04:41:37'.

     It is also possible to obtain other formats by using the type operand.
     Type  is  a single character used to  indicate  the type of  alternate
     format  desired.  The possible formats  are: 'C' Civil, 'H' Hours, 'L'
     Long, 'M' minutes, 'N' Normal, 'S' Seconds, or a number N to start  an
     N second timer.

	BAT * TIME() example
	Type "This example started at" TIME() "on" DATE()
	Type "Waiting 4 seconds..."
	Wait until TIME(4)
	Type "Done!"

end
	goto -scroll
-opt17
-line1326 %H = "CONTROL FUNCTIONS"| %i = 1326| call -header | begtype

~EBL/CONTROL FUNCTIONS~

The  EBL Control Functions determine the status of EBL	and  the  functions
being used. Like other functions, they can be used anywhere other values or
expressions are used.  For  example, in an assignment  statement, an IF  or
TYPE statement, etc.

~NOT( expression )~ The NOT()  function reverses the results of  true/false
     expressions.  This  is useful in IF  statements that use an expression
     or function to determine the next direction.


~VERSION()~ This function returns information describing the language level
     and  the  release	date of  this level.  It  consists  of	five  words
     separated by blanks.  For example
	 VERSION()  ==	"EBL 4.01a 23 Dec 1989"   (Perhaps)

end
	goto -scroll
-line1327 call -header | begtype
~TRACE( type )~  As an aid in debugging,  the  TRACE() function  enables  a
     trace flag which causes various types of  information to  be displayed
     as the EBL program executes.

     These traces are listed from the most quiet to the most verbose.  When
     a	more  verbose  level is active, all less  verbose results are  also
     shown.  For  example, TRACE(R) shows results,  all EBL statements, and
     DOS commands.

     -Trace Type-  -Meaning-	       -Symbols during Tracing-
	Trace()      Tracing off	 none
	Trace(O)     Tracing Off	 none
	Trace(C)     DOS Commands	 none
	Trace(A)     All statements	 *-*
	Trace(R)     Results		 *-*, >>>
	Trace(I)     Intermediates	 *-*, >>>, >F>, >E>, >V>, >L>
end
	goto -scroll
-line1328 call -header | begtype
~WHATFUNC()~ This command  should  be built into  all  function packages to
     identify  what is	loaded	and available.	This function is special in
     that  all external function package ID's  will  be  appended together.
     Each ID name will be separated by a  single space.  From  this  result
     you  can determine the order the functions were loaded, the  number of
     external functions available,  the  names of  each  package,  and	the
     functions associated with them.

     The ID  names for	the  set of external  functions provided by Seaware
     are:
	 Program Name		 ID Name
	 BATMATH3.COM		 BATMATH3
	 BMATH87.COM		 BATMATH87
	 Built into EBL 	 BATFUNC1.BATFUNC2

end
	goto -scroll
-line1329 call -header | begtype
~EBL OPTIONS~

A number of features within Extended Batch  Language are controlled through
EBL  options.  An  EBL option consists	of  a forward  slash  "/"  followed
immediately by an option  letter.  This will  set the requested feature  as
long as EBL remains active and does not return	to DOS. If you need to exit
to DOS	(for instance with a DOS command or  with the LEAVE statement), you
may wish to turn on the option again when EBL resumes its processing.

All  EBL  options   have  default  values.  These  have  been	chosen	for
compatibility with previous EBL  and for ease of use.  Using  these options
may change how your EBL program is written.

~ /A		    ~- Any DOS version, use with 4DOS and other types of DOS
~ /K		    ~- Kill
~ /R [filename]     ~- Run new file
~ /W		    ~- DesqView/MS Windows support
~ BIOS, RAM, or ANSI~- display speeds
end
	goto -scroll
-opt18
-line1330 %H = "ADD-ON FUNCTIONS"| %i = 1330| call -header | begtype
~ External Add-on Functions:~

Just like all the built-in functions previously described, you can add-on
your own custom functions external to EBL.  External Functions give
Extended Batch Language additional capabilities.  Within external functions
you can create helpful routines in writing complex EBL programs.
Generally, you will be able to write almost all of your EBL programs
without these functions.  Occasionally there may be some special need for a
unique operation that is not part of the commands built into Extended Batch
Language.  External functions can therefore be added to EBL as needed.

The most popular external functions from EBL version 3 (from BATFUNC1.COM
and BATFUNC2.COM) have been incorporated into EBL-PLUS.  Additional
functions and ideas are always invited.
end
	goto -scroll
-line1331 call -header | begtype

Adding external functions is not for the beginning programmer. To help
you along your way, we provide the following two samples with source code
to you when you register.

 ~BATMATH.EXE~	- Written in Turbo-Pascal, it takes advantage of Borland's
     high precision BCD math to provide floating point functions for EBL:
	  FLOAT() FRAC() INT() ABS()
     In addition, samples are provided to do hexadecimal conversions:
	  C2H() D2H() H2C() H2D()

 ~BATXV.COM~	- Written in Macro Assembler, it redirects the
     reading/saving of variables to a larger buffer. It also provides
     a way to create indexes and arrays within the buffer.
end
	  goto -scroll
-opt19
-line1332 %i = 1400
-line1400 %H = "Additional Information" | call -header| begtype
~Additional Information~

The size of the keyboard stack defaults to 1024 bytes.	This value can be
changed by making the first statement which is executed by the Extended
Batch Language program be of the form:	BAT * size.  Size is the decimal
number of bytes to reserve for the stack.  This must be executed, for
instance, when a system reset is performed because once this area is
installed, the size is never altered until another system reset.

There are additional variables %A thru %O (oh) which are called "global
user variables".  These variables are used exactly like the variables
supplied by DOS (%0 to %9) with two exceptions.  First, the contents of
these variables are maintained between execution of batch files for as long
as the system is powered on.  This "global" feature is useful for keeping
indicators BETWEEN "sessions" of the user.  Second, because DOS does not
know about these variables, they~can not~be used as variables within any
DOS command.  So while "COPY %1 %2" is valid, "COPY %A %B" is not.  If you
wish to use them within DOS commands, they must first be copied via a
statement like "BAT %1 = %A".
end
	  goto -scroll
-line1401 call -header | begtype
  PREDEFINED VARIABLES...

A return code is available at memory address [0000:04FE].  If set by a
program, EBL can read this byte value with the variable %R.  The string
stored into this variable is in hex with leading zeros truncated.

The current default drive is stored into the %V variable.  It is a single
character.

The status of the stack is stored into the %Q variable.  It is a "K" if the
READ command will be reading from the keyboard, and a "S" if it will be
reading from the stack area.

There are two character literals.  %S represents a space literal and %%
represents a percent sign.  Either of these special variables can be stored
into other variables, or used for testing special cases.
end
	  goto -scroll
-line1402 call -header | begtype
  If a you wish to put more than one command on a line, the vertical bar
"|" is useful.  When used with an IF command and the test for the IF
conditions fail, the entire rest of the line will be ignored.  Multiple
commands within a EBL statement is very useful when combined with the IF
command.  For example:

	IF %A = abc TYPE this | CALL -that | GOTO -other

  If a comment is needed within an EBL program, the "*" (star) character is
useful.  When used after the word EBL, all characters which follow will be
ignored.  For example:

	* This is a comment to the programmer.
end
	  goto -scroll
-line1403 call -header | begtype
If you still need more information, you might wish to contact our Internet
World Wide Web page at http://www.shadow.net/~seaware

If you find this program of value, you may purchase it for $49 at the
address below.	For further information, see section 2 of this document.

 Seaware Corp.						seaware@shadow.net
 Post Office Box 1656					      800/634-8188
 Delray Beach, FL 33444
end
	goto -scroll

-on.error-
	%e = %e + 1 | if %e > 2 then %L = ? | skip 4
	if %R <> 6 then skip 7
	%G = .goto.
	color 8f |type "Loading part 1 ..."
	leave
	batdoc
bat *
bat beep type "ERROR! BATDOC.BAT overlay is missing!"
bat exit

begtype

     Unexpected error \%S%R in line \%S%L !

     This batch file was error free when it was distributed
     by Seaware. An error indicates that it was most likely
     modified by someone improperly. To get an updated demo
     diskette send $10 to Seaware directly or contact our
     Internet Web page at http://www.shadow.net/~seaware

			Seaware Corp.
		     Post Office Box 1656
		    Delray Beach, FL 33444
end
%G =
%E = 0
exit
